/**
 * The following client recieves an autheticated message from another client via the router
 *
 */
#define __USE_BSD	
#include <sys/socket.h>	
#include <netinet/in.h>	
#include <netinet/ip.h>
#include <arpa/inet.h>
#define __FAVOR_BSD	
#include <netinet/udp.h>
#include <netinet/udp.h>
#include <unistd.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "address.h"

/** 
 * The combined structures for IP header and TCP/UDP Header. 
 * The individual structures are included in the header file
 *
 * <netinet/ip.h>
 * <netinet/udp.h>
 * 
 * The exact attributes present in these structures can be refrenced 
 * form these header files.
 */
struct protoUDP {
	struct ip iphdr;
	struct udphdr udph;
};

int main (void)
{
        int sock_in;  
        struct sockaddr_in client2_addr, router_addr; 
        
	if ((sock_in = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
            perror("Socket");
            exit(1);
        }

	client2_addr.sin_family = AF_INET;         
        client2_addr.sin_port = htons(DST_PORT);     
        client2_addr.sin_addr.s_addr = INADDR_ANY; 
        bzero(&(client2_addr.sin_zero),8); 

        if (bind(sock_in, (struct sockaddr *)&client2_addr, sizeof(struct sockaddr))
                                                                       == -1) {
            perror("Unable to bind");
            exit(1);
        }

	char buffer[4096];
	int a;
	int addrlen;
	while (1) {
		memset (buffer, 0, 4096);

		addrlen = sizeof(router_addr);
		if ((a=recvfrom(sock_in, buffer, sizeof(buffer) , 0, (struct sockaddr *)&router_addr, &addrlen)) == -1) {
			perror("recv");
		}
		else {
//			printf("Received %d byte \n", a);
			struct protoUDP *udp = (struct protoUDP*) buffer;
			IP_addr src_addr = udp->iphdr.ip_src.s_addr;
			IP_addr dst_addr = udp->iphdr.ip_dst.s_addr;
			// Change type of protocol in firewall_check to integer type !!!
			int protocol = udp->iphdr.ip_p;
			
			int src_port = udp->udph.uh_sport;
			int dst_port = udp->udph.uh_dport;
			
//			printf("src_addr: %d\n",src_addr);
//			printf("check: %d\n", inet_addr (SRC_ADDR));
//			printf("dst_addr: %d\n",dst_addr);
//			printf("check: %d\n",inet_addr (DST_ADDR));
			
//			printf("SRC PORT: %d\n", ntohs(src_port));
//			printf("DST PORT: %d\n", ntohs(dst_port));
			
			printf("Received: %s\n", (char *)buffer + sizeof (struct protoUDP));
		}
	}
	close(sock_in);
/** Receiving of message finished...now sending ACK */
/**
	char datagram[4096];
	
	struct protoUDP *Z = (struct protoUDP *)datagram;
	memset (datagram, 0, 4096);	

	Z->iphdr.ip_hl = 5;
	Z->iphdr.ip_v = 4;
	Z->iphdr.ip_tos = 0;
	Z->iphdr.ip_len = sizeof (struct ip) + sizeof (struct udphdr) ;
	Z->iphdr.ip_id = htonl (54321);	
	Z->iphdr.ip_off = 0;
	Z->iphdr.ip_ttl = 155;
	Z->iphdr.ip_p = 17;
	Z->iphdr.ip_sum = 0;		
	Z->iphdr.ip_src.s_addr = inet_addr (DST_ADDR);
	Z->iphdr.ip_dst.s_addr = inet_addr (SRC_ADDR);

	Z->udph.uh_sport = htons (DST_PORT);	
	Z->udph.uh_dport  = htons (SRC_PORT);
	Z->udph.uh_ulen = sizeof (struct udphdr) ;
		
	struct sockaddr_in router2_addr;
	int sock_out;
	
	if ((sock_out = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
            perror("Socket");
            exit(1);
        }
  	router2_addr.sin_family = AF_INET;     
	router2_addr.sin_port = htons(ROUTER_PORT);   
	router2_addr.sin_addr.s_addr = inet_addr (ROUTER_ADDR);
	printf ("##########\n");
	int sent_bytes = sendto (sock_out, datagram, Z->iphdr.ip_len, 0, (struct sockaddr *) &router2_addr, sizeof (router2_addr));
	printf ("!!!!!!!!!!\n");
	if (sent_bytes < 0) printf ("error\n");
	else printf ("Sent bytes = %d\n",sent_bytes);

	close(sock_out);  
*/
	return 0;
}
