/**
 * The following client recieves an autheticated message from another client via the router
 *
 */

#define __USE_BSD	
#include <sys/socket.h>	
#include <netinet/in.h>	
#include <netinet/ip.h>
#include <arpa/inet.h>
#define __FAVOR_BSD	
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <unistd.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "address.h"

/** 
 * The combined structures for IP header and TCP/UDP Header. 
 * The individual structures are included in the header file
 *
 * <netinet/ip.h>
 * <netinet/tcp.h>
 * 
 * The exact attributes present in these structures can be refrenced 
 * form these header files.
 */
struct protoTCP {
	struct ip iphdrdr;
	struct tcphdr tcph;
};

int main (void)
{
        int sock_in;  
        struct sockaddr_in client2_addr, router_addr; 
        
	if ((sock_in = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
            perror("Socket");
            exit(1);
        }

	client2_addr.sin_family = AF_INET;         
        client2_addr.sin_port = htons(DST_PORT);     
        client2_addr.sin_addr.s_addr = INADDR_ANY; 
        bzero(&(client2_addr.sin_zero),8); 

        if (bind(sock_in, (struct sockaddr *)&client2_addr, sizeof(struct sockaddr))
                                                                       == -1) {
            perror("Unable to bind");
            exit(1);
        }

	char buffer[4096];
	int a;
	int addrlen;
	
	while (1) {
		memset (buffer, 0, 4096);

		addrlen = sizeof(router_addr);
		if ((a=recvfrom(sock_in, buffer, sizeof(buffer) , 0, (struct sockaddr *)&router_addr, &addrlen)) == -1) {
			perror("recv");
		}
		else {
		//printf("Received %d byte \n", a);

			struct protoTCP *tcp = (struct protoTCP*) buffer;
			IP_addr src_addr = tcp->iphdrdr.ip_src.s_addr;
			IP_addr dst_addr = tcp->iphdrdr.ip_dst.s_addr;
			// Change type of protocol in firewall_check to integer type !!!
			int protocol = tcp->iphdrdr.ip_p;
			
			int src_port = tcp->tcph.th_sport;
			int dst_port = tcp->tcph.th_dport;
			
		//	printf("src_addr: %d\n",src_addr);
		//	printf("check: %d\n", inet_addr (SRC_ADDR));
		//	printf("dst_addr: %d\n",dst_addr);
		//	printf("check: %d\n",inet_addr (DST_ADDR));
			
		//	printf("SRC PORT: %d\n", ntohs(src_port));
		//      printf("DST PORT: %d\n", ntohs(dst_port));
			
			printf("Recieved: %s\n", (char *)buffer + sizeof (struct protoTCP));
		}
	}
	close(sock_in);
	return 0;
}
