/**
 * The following client sends a message to another client via the router
 * Sends a packet with UDP header.
 */
#define __USE_BSD	
#include <sys/socket.h>	
#include <netinet/in.h>	
#include <netinet/ip.h>
#include <arpa/inet.h>
#define __FAVOR_BSD	
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <unistd.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "address.h"

/** 
 * The combined structures for IP header and TCP/UDP Header. 
 * The individual structures are included in the header file
 *
 * <netinet/ip.h>
 * <netinet/udp.h>
 * 
 * The exact attributes present in these structures can be refrenced 
 * form these header files.
 */
struct protoUDP {
	struct ip iphdr;
	struct udphdr udph;
};

int main (int argc, char *argv[])
{

	char datagram[4096];
	struct protoUDP *Z = (struct protoUDP *)datagram;
	memset (datagram, 0, 4096);	/* zero out the buffer */

	if (argc == 1){
		fprintf (stderr, "Usage:%s <message> /*Type message to be sent.*/\n", argv[0]);
		exit(1);
	}	

	char *message = (char *) malloc (sizeof (char *));
	int i = 1;
	while (i < argc) {
		strcat (message, " ");
		strcat (message, argv[i]);
		i++;
	}
	
	Z->iphdr.ip_hl = 5;				// Header length
	Z->iphdr.ip_v = 4;				// version number
	Z->iphdr.ip_tos = 0;				// type of service
	Z->iphdr.ip_len = sizeof (struct ip) + sizeof (struct tcphdr) + strlen(message); // packet length
	Z->iphdr.ip_id = htonl (54321);			// packet id
	Z->iphdr.ip_off = 0;				// offset
	Z->iphdr.ip_ttl = 255;				// time to live
	Z->iphdr.ip_p = 17;				// protocol (TCP = 6)
	Z->iphdr.ip_sum = 0;				
	Z->iphdr.ip_src.s_addr = inet_addr (SRC_ADDR);	// source IP address
	Z->iphdr.ip_dst.s_addr = inet_addr (DST_ADDR);	// destination IP address

	Z->udph.uh_sport = htons (SRC_PORT);		// source port number
	Z->udph.uh_dport  = htons (DST_PORT);		// destination port number
	Z->udph.uh_ulen = sizeof (struct udphdr) + strlen(message); // header length
		
//	printf("size of ip %d\n", sizeof (struct ip));
//	printf("size of udp %d\n", sizeof (struct udphdr));
//	printf("size of message %d\n", strlen(message));

	strcpy ((char *) datagram + sizeof (struct protoUDP), message);

	struct sockaddr_in router_addr;
	int sock_out;
	
	if ((sock_out = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
            perror("Socket");
            exit(1);
        }
  	router_addr.sin_family = AF_INET;     
	router_addr.sin_port = htons(ROUTER_PORT);   
	router_addr.sin_addr.s_addr = inet_addr (ROUTER_ADDR);

	int sent_bytes = sendto (sock_out, datagram, Z->iphdr.ip_len, 0, (struct sockaddr *) &router_addr, sizeof (router_addr));
	if (sent_bytes < 0) printf ("error\n");
	else printf ("Message sent to router\n");
		//printf ("Sent bytes = %d\n",sent_bytes);
	close(sock_out);  

/** Sending of message finished */
/** waiting for reply from FIREWALL if packet is dropped */
	int sock_in;  
        struct sockaddr_in client1_addr, router1_addr; 
        
	if ((sock_in = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
            perror("Socket");
            exit(1);
        }

	client1_addr.sin_family = AF_INET;         
        client1_addr.sin_port = htons(SRC_PORT);     
        client1_addr.sin_addr.s_addr = INADDR_ANY; 
        bzero(&(client1_addr.sin_zero),8); 

        if (bind(sock_in, (struct sockaddr *)&client1_addr, sizeof(struct sockaddr)) == -1) {
            perror("Unable to bind");
            exit(1);
        }

	char buffer[4096];
	int a;
	int addrlen;
	
		memset (buffer, 0, 4096);

		addrlen = sizeof(router1_addr);
//		printf("waiting\n");
		if ((a=recvfrom(sock_in, buffer, sizeof(buffer) , 0, (struct sockaddr *)&router1_addr, &addrlen)) == -1) {
			perror("recv");
		}
		else {
			//printf("Received %d byte \n", a);		
			printf("Received: %s\n", (char *)buffer + sizeof (struct protoUDP));
		}
	close(sock_in);
	return 0;
}
