#ifndef OBERON_TYPES
#define OBERON_TYPES

//BASIC TYPES
#define tBOOLEAN     0
#define tCHAR        1
#define tSHORTINT    2
#define tINTEGER     3
#define tLONGINT     4
#define tREAL        5
#define tLONGREAL    6
#define tSET         7
#define tVOID        8
//ERROR TYPE 	
#define tERROR 		 9
//DERIVED TYPES
#define tARRAY       10
#define tRECORD      11
#define tPOINTER     12
#define tPROCEDURE   13


#include <string>
#include <list>
#include "ic.h"

typedef union {
  int i;
  double f;
} Val;

class Scope;

class desigvar{
  public:
  string var;
  int dclass;
  argument *arg;
  desigvar(string var, int dclass=0, argument *arg=NULL){
    this->var=var;
    this->dclass=dclass;
    this->arg=arg;
  }
  desigvar(){
    var="";
    dclass=0;
    arg=NULL;
  }
};

class TypeSpecifier{
  public:
    int node;               // Contains the type constructor if it is a derived type or the basic type.
                            // if node = -1, type is "TYPE"
    int n;                  // Number of children (from which the type is derived)
                            // If type is "ARRAY", n represents the dimension of the array.

    TypeSpecifier **child;
    int *dimns;             //optional (used for arrays)
    int width;
    Scope * rectab;

    TypeSpecifier(int nd=-1, int size=0){
      n=0;
      child=NULL;
      rectab=NULL;
      node=nd;
      width=size;
    }

    ~TypeSpecifier(){
      for(int i=0; i<n; i++)
        delete child[i];
    }
    void print();

};

class Node{
  public:
  TypeSpecifier * type;
  instrlist * code;
  list <string *> True;
  list <string *> False;
  list <string *> Next;
  int cons; //0 if not const, 1 for int, 2 for real, 3 for boolean code
  int desigType; //1 for array, 2 for record, default 0
  desigvar dv;
  bool suffixEnd;
  argument val;
  Node (TypeSpecifier * t=NULL, instrlist * c=NULL, int co=0){
    type=t;
    code=c;
    cons=co;
    suffixEnd=false;
  }
};

struct NodeList{
  Node * head;
  NodeList * tail;
  int size;
};

struct ConstE{
  int val;
  bool error;
};

struct ConstList{
  ConstE head;
  bool error;
  ConstList * tail;
  int size;
};

extern TypeSpecifier * basicType[10];
bool CheckEquivalence(TypeSpecifier * type1, TypeSpecifier * type2);
bool CheckEquivalence(void * type1, void * type2);
bool validateFunctionCall(TypeSpecifier * fntype, NodeList* arglist,int line);
bool isArithmetic( TypeSpecifier *t);
bool TypeExpandable (TypeSpecifier * t1, TypeSpecifier * t2);
bool isArithComparable(TypeSpecifier *t1, TypeSpecifier *t2);
void typeError(int id, TypeSpecifier *t1, TypeSpecifier *t2, int line);
TypeSpecifier * assign_rel_type( TypeSpecifier *t1, TypeSpecifier *t2, int line);
TypeSpecifier * assign_add_type( TypeSpecifier *t1, TypeSpecifier *t2, int line);
#endif

