#ifndef SCOPEOBERON
#define SCOPEOBERON
#include <tr1/unordered_map>
#include <string>
#include <algorithm>
#include <map>
#include <iterator>
#include "type.h"
#include <cstdio>

class Scope;

class Entry{
  public:
    TypeSpecifier * type;
    int offset;
    int depth;
    string label;               // to facilitate jump on function call
    bool used;                  // If a variable is unused, give a warning during compile time.
    Scope * nextenv;            // For records and procedures
    
    Entry(int o=0, bool u=false, Scope * n=NULL /*,varLocation v=varLocation() */){
      offset=o;
      used=u;
      nextenv=n;
    }
}; 

typedef std::tr1::unordered_map<std::string, Entry *> SymbolTable;
typedef SymbolTable::iterator TableIterator;
extern int depth;
class Scope{

  private: 
    SymbolTable table;
    Scope *prev;
    int currentOffset;
    int paramOffset;
    int base;
    

  public:
    int depth;
    Scope(Scope *p=NULL){
      prev=p;
      if(p)
        depth=p->depth+1;
      else
        depth=0;
      table=SymbolTable();
      currentOffset=0;
      paramOffset=-12;
      base=0;
    }

    int declare(std::string id, TypeSpecifier * t, Scope * s=NULL);
    int paramDeclare(std::string id, TypeSpecifier * t, Scope * s=NULL);
    int insertType(std::string, TypeSpecifier *);
    Entry * lookup(std::string);
    Entry * localLookup(std::string);
    Scope * getPrev();
    int getBase();
    void setPrev(Scope * p);
    int getOffset();
    void showAll();
    void deleteStuff();
};
#endif
