/*HEADER{{{
 * =============================================================
 *       Filename:  scope.cpp
 *        Created:  Tuesday 12 April 2011 12:46:40  IST
 *         Author:  Shitikanth (), shiti@iitk.ac.in
 *        Company:  IIT Kanpur
 * =============================================================
 }}} */

#include "scope.h"
#include <cassert>

int depth=0;
Scope* Scope::getPrev(){
      return prev;
    }
    
int Scope::getBase(){
  return base;
}

int Scope::insertType(std::string id, TypeSpecifier *t){
  if(table.find(id)==table.end()){
    Entry *entry= new Entry();
    entry->type=new TypeSpecifier();
    entry->type->n=1;
    entry->type->child= new TypeSpecifier *[1];
    entry->type->child[0] = t;
    table.insert(make_pair(id,entry));
    return 1;
  }
  return 0;
}

Entry * Scope::lookup(std::string id){ 
  TableIterator it;
  it=table.find(id);
  if(it!=table.end())
    return it->second;
  if(prev==NULL)
    return NULL;
  return prev->lookup(id);
}

Entry * Scope::localLookup(std::string id){
  TableIterator it;
  it=table.find(id);
  if(it!=table.end())
    return it->second;
  else
    return NULL;
}

void Scope::showAll(){
  TableIterator it;
  printf("Showing contents of Symbol Table\n");
  printf("-----------------\n");
  int i=0;
  for(it=table.begin(); it!=table.end(); it++){
    printf("%d - %s => ",++i,it->first.c_str());
    it->second->type->print();
    printf(" %d %d || depth = %d\n",it->second->type->width,it->second->offset,it->second->depth);
    if(it->second->nextenv){
      printf("\n");
      it->second->nextenv->showAll();
    }
  }
  printf("\n\n");
}

int Scope::getOffset(){
  return currentOffset;
}
void Scope::deleteStuff(){
  TableIterator it;
  printf("Deleting contents of Symbol Table\n");
  int i=0;
  for(it=table.begin(); it!=table.end(); it++){
    delete it->second->type;
  }
}

int Scope::declare(std::string id, TypeSpecifier *t, Scope *s){
  assert(t!=NULL);
  if(table.find(id)==table.end()){
    Entry *entry= new Entry();
    entry->type=t;
    entry->offset=currentOffset+entry->type->width;
    entry->nextenv=s;
    entry->depth=depth;
    
     // moving symbol table from record type to record variable
     
      if (t->node==tRECORD){
       entry->nextenv = t->rectab;
       t->rectab->prev = this;
      }
     
    currentOffset+=t->width;
    table.insert(make_pair(id,entry));
    return 1;
  }
  return 0;
}

int Scope::paramDeclare(std::string id, TypeSpecifier *t, Scope *s){
  assert(t!=NULL);
  if(table.find(id)==table.end()){
    Entry *entry= new Entry();
    entry->type=t;
    entry->offset=paramOffset;
    entry->nextenv=s;
    entry->depth=depth; 
     // moving symbol table from record type to record variable
     
      if (t->node==tRECORD){
       entry->nextenv = t->rectab;
       t->rectab->prev = this;
      }
     
    paramOffset-=t->width;
    table.insert(make_pair(id,entry));
    return 1;
  }
  return 0;
}

void Scope::setPrev(Scope *p){
  prev=p;
}
