/*HEADER{{{
 * =============================================================
 *       Filename:  reg.h
 *        Created:  Monday 11 April 2011 01:20:19  IST
 *         Author:  Shitikanth (), shiti@iitk.ac.in
 *        Company:  IIT Kanpur
 * =============================================================
 }}} */
#ifndef REG_MAN
#define REG_MAN

#define INT 1
#define FLOAT 2
#define SPECIAL 0

#include <string>
#include <map>
#include <list>
#include "scope.h"
using namespace std;

/*
 * Classes and functions to handle register management.
 *
 */

class Register{
  string name;
  bool used;
  bool loaded;
  bool dirty;
  list<string> varinReg;

  public:
    Register(string n);
    Register();
    string getName();
  friend class RegisterHandler;
  friend Register * getRegister(string,bool );
};

class RegisterHandler{

  public:

  Register t[10],s[8],flo[32],v[2];
  map<string, Register *> varToReg;
  int genCount, floCount;
  RegisterHandler();
  Register * getGenRegister(string s="");
  Register * getFloRegister(string s="");
  void cleanTable(Scope *);
};
#endif
