/*HEADER{{{
 * =============================================================
 *       Filename:  reg.cpp
 *        Created:  Monday 11 April 2011 09:44:34  IST
 *         Author:  Shitikanth (), shiti@iitk.ac.in
 *        Company:  IIT Kanpur
 * =============================================================
 }}} */

#include <cstdio>
#include <string>
#include "reg.h"
#include "codegen.h"
#include <cassert>
using namespace std;

Register::Register(string n){
  name=n;
  used=false;
  dirty=false;
}

Register::Register(){
  name="";
  used=false;
  dirty=false;
}


string Register::getName(){
  return name;
}


RegisterHandler::RegisterHandler(){
  char str[10];
  genCount=0;
  floCount=0;
  for(int i=0; i<32; i++){
    sprintf(str,"$f%d",i);
    flo[i].name=str;
  }

  for(int i=0; i<10; i++){
    sprintf(str,"$t%d",i);
    t[i].name=str;
  }

  for(int i=0; i<8; i++){
    sprintf(str,"$s%d",i);
    s[i].name=str;
  }
  v[0].name="$v0";
  v[1].name="$v1";
}


Register * RegisterHandler::getFloRegister(string name){
  Register * r = varToReg[name];
  if(r){
    return r;
  }

  else{
    r=(flo+floCount);
    floCount++;
    varToReg[name]=r;
    return r;
  }
}

Register * RegisterHandler::getGenRegister(string name){
  Register * r = varToReg[name];
  if(r){
    return r;
  }
  else{
    if(genCount<10)
      r=t+genCount;
    else{
      assert(genCount<18);
      r=s+(genCount-10);
    }
    if(name.compare("")!=0){
      varToReg[name]=r;
    }
    genCount++;
    return r;
  }
}
void RegisterHandler::cleanTable(Scope *Env){
  map<string, Register *>::iterator it;
  for(it = varToReg.begin(); it!=varToReg.end();it++){
    string str=it->first;
    if((int)str.find("_TEMP")!=0){
      Register *r = varToReg[str];
      if(r){

        int np = Env->depth-1;
        Entry * e = Env->lookup(str);

        if(e){
          int nq = e->depth-1;
          if (np<nq){
            assert(false);
          }
          else{
            int hops= np-nq;
            code("\tmove $a0, $fp\n");
            while(hops>0){
              code("\tlw $a0, ($a0)\n");
              hops--;
            }
          }

          code("\tsw ");
          code("%s",varToReg[str]->getName().c_str());
          code(", %d($a0)\n",-(e->offset));
        }
        else{
          printf("ajab gajab - %s\n",str.c_str());
        }
      }
    }
  }
  varToReg.clear();
}


