/*HEADER{{{
 * =============================================================
 *       Filename:  optimize.h
 *        Created:  Wednesday 13 April 2011 01:33:22  IST
 *         Author:  Shitikanth (), shiti@iitk.ac.in
 *        Company:  IIT Kanpur
 * =============================================================
 }}} */

#ifndef OBERON_OPTIMIZE
#define OBERON_OPTIMIZE

#include <vector>
using namespace std;

class instr;
class instrlist;

class FGNode{
  instrlist * code;
  vector < FGNode * > adjacency;
  FGNode();
  FGNode(instr * cur);
  friend class flowGraph;
};

class flowGraph{
  vector < FGNode *> nodes;
  FGNode * start;
  
  static void fillupTable(instrlist * orig);
  public:
  //void optimize();
  void setStart(FGNode *);
  void addNode(FGNode *);
  void addEdge(FGNode *, FGNode *);
  void printLeaders();
  void print();
  instrlist * generateIC();
  static flowGraph generateFG(instrlist *);
  static instr * firstReachableLabel(instr * cur, instrlist * orig);
  static void deadCodeRemoval(flowGraph fg, instrlist *);
};

#endif
