/*HEADER{{{
 * =============================================================
 *       Filename:  optimize.cpp
 *        Created:  Wednesday 13 April 2011 01:36:53  IST
 *         Author:  Shitikanth (), shiti@iitk.ac.in
 *        Company:  IIT Kanpur
 * =============================================================
 }}} */

#include "optimize.h"
#include "ic.h"
#include <tr1/unordered_map>
#include <set>
#include <string>
#include <algorithm>
#include <vector>
#include <set>
#include <queue>
#include <map>
#include <cassert>
#include "codegen.h"

using namespace std;

typedef tr1::unordered_map<string, instr *> LabelTable;
typedef LabelTable::iterator TableIterator;

set<string> reachableLabels;

LabelTable table;

FGNode::FGNode(){
  code = new instrlist;
}

FGNode::FGNode(instr * cur){
  code = new instrlist;
  code->head = cur;
}

void flowGraph::setStart(FGNode *node){
  start = node;
}

void flowGraph::addNode(FGNode * node){
  nodes.push_back(node);
}

void flowGraph::addEdge(FGNode * u , FGNode * v){
  u->adjacency.push_back(v);
}

void flowGraph::printLeaders(){
  for(int i=0; i<nodes.size(); i++){ 
    nodes[i]->code->head->print();
    printf("\t\t:=> ");
    if(nodes[i]->code->tail)
      nodes[i]->code->tail->print();
    else
      printf("NULL\n");
  }
}

void flowGraph::print(){
  for(int i=0; i<nodes.size(); i++){ 
    printf("%d :",(int)nodes[i]);
    for(int j=0; j<nodes[i]->adjacency.size(); j++){
      printf(" %d",(int)nodes[i]->adjacency[j]);
    }
    printf("\n");
  }
}

instr * lookup(std::string id){ 
  TableIterator it;
  it=table.find(id);
  if(it!=table.end())
    return it->second;
  return NULL;
}

void flowGraph::deadCodeRemoval(flowGraph fg, instrlist *orig){
  queue<FGNode *> visiting;
  set<FGNode *> discovered;

  FGNode * cur =fg.start;
  visiting.push(cur);
  discovered.insert(cur);

  while(!visiting.empty()){
    cur = visiting.front();
    visiting.pop();
    for (vector<FGNode*>::iterator it=cur->adjacency.begin(); it!=cur->adjacency.end();++it){
      if (discovered.find(*it)==discovered.end())
        visiting.push(*it);
      discovered.insert(*it);
    }
  }

  for (vector<FGNode*>::iterator it=fg.nodes.begin(); it!=fg.nodes.end();++it){
    if (discovered.find(*it)==discovered.end()){
      instrlist * codetoremove = (*it)->code;
      if(codetoremove->tail==NULL){        
        instr * prev = NULL;
        instr * cur = codetoremove->head;
        while(cur){
          prev=cur;
          cur=cur->next;
        }
        codetoremove->tail=prev;
      }
      orig->remove(codetoremove);
    }
  }
}


void flowGraph::fillupTable(instrlist * orig){
  FGNode * node;
  if(!orig)
    return;
  instr * cur = orig->head;
  while(cur){
    if(cur->op==LABEL){
      table.insert(make_pair(cur->result,cur));
      size_t found = cur->result.find("_FUNCTION");
      if((int)found==0){
        reachableLabels.insert(cur->result);
      }
    }
    else if(cur->op==JUMP||cur->op==CJUMP){
      reachableLabels.insert(*(cur->label));
    }
    cur=cur->next;
  }
}


// finds the first reachable instruction, till then deletes
instr * flowGraph::firstReachableLabel(instr * cur, instrlist * orig){
  // removing dead code
  while(cur && cur->op!=LABEL){
    instr *t =cur;
    orig->remove(t);
    cur=cur->next;
  }
  if (!cur) return NULL;

  bool flag = reachableLabels.find(cur->result)!=reachableLabels.end();
  if(!flag){
    instr *t = cur;
    orig->remove(t);
    return firstReachableLabel(cur->next,orig);
  }
  return cur;
}

flowGraph flowGraph::generateFG(instrlist * orig){
  flowGraph fg;
  if(orig==NULL || (orig->head)==NULL )
    return fg;
  fillupTable(orig);
  FGNode * node;
  map <string,FGNode *> labelNode;
  instr * in;

  for (set<string>::iterator it=reachableLabels.begin(); it!=reachableLabels.end(); it++){
    in = lookup(*it);
    assert(in);
    node = new FGNode(in);
    fg.addNode(node);
    labelNode[*it]=node;
  }

  instr * cur = orig->head;
  instr * prev;
  FGNode *curNode;

  if  (cur->op==LABEL){
    if (reachableLabels.find(cur->result)!=reachableLabels.end()){
      curNode = labelNode[cur->result];
      cur=cur->next;
      fg.setStart(curNode);
    }
    else{
      curNode =  new FGNode(cur);
      fg.addNode(curNode);
      fg.setStart(curNode);
    }
  }
  else{
    curNode =  new FGNode(cur);
    fg.addNode(curNode);
    fg.setStart(curNode);
  }

  // insert curr node in the flowgraph at the start
  while(cur){
    if(cur->op==LABEL){
      bool flag = reachableLabels.find(cur->result)!=reachableLabels.end();
      if(!flag){
        instr *t = cur;
        cur=cur->next;
        orig->remove(t);
      }
      else{
        FGNode * nxtNode = labelNode[cur->result];
        // insert a dependecy from curNode to nxtNode
        fg.addEdge(curNode,nxtNode);
        curNode->code->tail = cur->prev;
        curNode = nxtNode;
        cur=cur->next;
      }
    }
    else if(cur->op==JUMP){
      FGNode *jumpNode = labelNode[*(cur->label)];
      // insert a dependency from curNode to jumpNode
      fg.addEdge(curNode,jumpNode);
      curNode->code->tail = cur;

      cur = firstReachableLabel(cur->next,orig);

      if(!cur) break;
      FGNode * nxtNode = labelNode[cur->result];
      curNode = nxtNode;
      cur=cur->next;
    }
    else if(cur->op==CALL){
      FGNode *procNode = labelNode[*(cur->label)];
      // insert a dependency from curNode to jumpNode
      fg.addEdge(curNode,procNode);
      //curNode->code->tail = cur;

      cur=cur->next;
      /*
      if(!cur) break;
      // if curr instruction is label use its node, otherwise
      // create a new node and add it to graph
      FGNode * nxtNode;
      if (cur->op==LABEL || reachableLabels.find(cur->result)!=reachableLabels.end()){
      ;
      }
      else{
          nxtNode = new FGNode(cur);
          fg.addNode(nxtNode);
          fg.addEdge(curNode,nxtNode);
          curNode = nxtNode;
      }
      */
    }
    else if(cur->op==CJUMP){
      assert(cur->next->op==JUMP);
      FGNode *jumpNode = labelNode[*(cur->label)];
      // insert a dependency from curNode to jumpNode
      fg.addEdge(curNode,jumpNode);
      cur=cur->next;
      jumpNode = labelNode[*(cur->label)];
      // insert a dependency from curNode to jumpNode
      fg.addEdge(curNode,jumpNode);

      curNode->code->tail = cur;

      cur = firstReachableLabel(cur->next,orig);
      if (!cur) break; //flowgraph
      FGNode * nxtNode = labelNode[cur->result];
      curNode = nxtNode;
      cur=cur->next;
    }
    else{
      cur=cur->next;
    }
  }
  curNode->code->tail=NULL;
  for(int i=0; i<fg.nodes.size(); i++){
    //leaders.insert(fg.nodes[i]->code->head);
  }
  return fg; //flowgraph
}

