/*HEADER{{{
 * =============================================================
 *       Filename:  icgen.cpp
 *        Created:  Monday 04 April 2011 10:44:48  IST
 *         Author:  Shitikanth (), shiti@iitk.ac.in
 *        Company:  IIT Kanpur
 * =============================================================
 }}} */

#include"icgen.h"
#include<iterator>
#include<cstdio>
#include<cassert>

int tempCount=0;
int labelCount=0;
int funcCount=0;

/* char * getTemp();{{{
 *
 * Returns the next temporary variable to use. Also creates a symbol table
 * entry if needed.
 *
 */

char * getTemp(){
  char * ans = new char[100];
  sprintf(ans,"_TEMP%d",tempCount++);
  return ans;
}
// }}}
/* string newLabel();{{{
 *
 * Return the next label for use.
 */

string newLabel(){
  string s;
  char ans[100];
  sprintf(ans,"_LABEL%d",labelCount++);
  s=string(ans);
  return s;
}
//}}}
/* char * newFunction();{{{
 *
 * Returns the next function label to use.
 *
*/
string newFunction(){
  char ans[100];
  sprintf(ans,"_FUNCTION_%d",funcCount++);
  return string(ans);
}
//}}}
/* string * getLabelBox();{{{
 * 
 * Returns a new LabelBox for use.
 *
 */
string * getLabelBox(){
  string **s1;
  s1=new string *;
  *s1=new string;
  return *s1;
}
//}}}
/* void backpatch(list<string *> l, string s);{{{
 *
 * Backpatch the list of LabelBoxes with the provided label;
 *
 */
void backpatch(list<string *> l, string s){
  for(list<string *>::iterator it =l.begin(); it!=l.end(); it++){
    *(*it) = s;
  }
}
//}}}
/*void merge(list<string *> &l1, list<string *> &l2);{{{
 *
 *Merge list of label boxes
 *
 */
void merge(list<string *> &l1, list<string *> &l2){
  l1.splice(l1.end(),l2);
}
//}}}
void genRelIC(Node * Res, Node *Arg1, Node *Arg2, relation r){
  string * s1 = getLabelBox();
  string * s2 = getLabelBox();
  Res->True.push_back(s1);
  Res->False.push_back(s2);
  instrlist *list = new instrlist();
  list->append(Arg1->code);
  list->append(Arg2->code);
  instr *inst1, *inst2;
  inst1 = instr::ic_cjump(r,&Arg1->val,&Arg2->val,s1);
  inst2 = instr::ic_jump(s2);
  list->addinstr(inst1);
  list->addinstr(inst2);
  Res->code = list;
}

void genICRecordR(Node * Res, string ident, Node * Suff, string tempvar, string parentvar, bool flag){
  Res->val.c = 0;
  Res->cons = 0;

  instrlist * reccall = new instrlist;
  instr * in;
  if(!flag){
    in = instr::ic_2arg(RECR,makearg(parentvar),makearg(ident),tempvar); 
    reccall->addinstr(in);
  }
  else{
    designatorVar.push(desigvar(parentvar,2,makearg(ident)));
  }
  reccall->append(Suff->code);
  Res->code = reccall;
}

void genICArrayR(Node * Res, NodeList * Exprs, Node * Suff, string tempvar, string parentvar, bool flag){
  assert(Exprs->size==Res->type->n);
  Res->val.c = 0;
  Res->cons = 0;

  instrlist * arrcall = new instrlist;
  instr * in;
  NodeList * nl = Exprs;
  string *runErr = new string("_RUNTIME");

  for(int i=0; i<Exprs->size; i++){
    arrcall->append(nl->head->code);
    nl=nl->tail;
  }
  nl = Exprs;
  for(int i=0; i<Exprs->size; i++){
    string * l = new string(newLabel());
    in = instr::ic_cjump(R_L,&nl->head->val,makearg(Res->type->dimns[i]),l);
    arrcall->addinstr(in);
    in = instr::ic_jump(runErr);
    arrcall->addinstr(in);
    in = instr::ic_label(*l);
    arrcall->addinstr(in);
    nl = nl->tail;
  }
  nl = Exprs;
  //TODO
  string t,t1,t2;
  argument *a,*a1,*s;
  if (Exprs->size==1){
    a = &nl->head->val; 
  }
  else{
    t = getTemp();
    a = makearg(t);
    in = instr::ic_2arg(OP_COPY,a,&nl->head->val,"");
    nl = nl->tail;
    arrcall->addinstr(in);
    for(int i=0; i<Exprs->size-1; i++){ 
      t1= getTemp();
      t2 = getTemp();
      s = makearg(Res->type->dimns[i]);
      in=(instr::ic_2arg(OP_MUL,a,s,t1));
      arrcall->addinstr(in);
      in=instr::ic_2arg(OP_ADD,makearg(t1),&nl->head->val,t2);
      arrcall->addinstr(in);
      nl = nl->tail;
      a = makearg(t2);
    }
  }
  if(!flag){
    in = instr::ic_2arg(ARRR,makearg(parentvar),a,tempvar); 
    arrcall->addinstr(in);
  }
  else{
    designatorVar.push(desigvar(parentvar,1,a));
  }

  arrcall->append(Suff->code);
  Res->code = arrcall;
}

void genICFunc(Node * Res, NodeList * Exprs, string tempvar, string parentvar){

  instrlist * list = new instrlist;
  instr * in;
  NodeList * nl = Exprs;

  Res->val.c = 0;
  Res->cons = 0;
  Res->val.argval.var = tempvar;

  for(int i=0; i<Exprs->size; i++){
    list->append(nl->head->code);
    nl=nl->tail;
  }

  nl = Exprs;

  for(int i=0; i<Exprs->size; i++){
    in=instr::ic_1arg(PARAM,&nl->head->val,"");
    list->addinstr(in);
    nl=nl->tail;
  }

  in=instr::ic_call(parentvar);
  list->addinstr(in);
  in = instr::ic_2arg(OP_COPY,makearg(tempvar),makearg("_RV"),"");
  list->addinstr(in);
  Res->code = list;
}
void genIC(Node *Res, Node *Arg1, Node *Arg2, opcode OP){
  if(Arg1->cons && ((Arg2==NULL||Arg2->cons))){
    if(Arg2!=NULL){
      Res->cons = max(Arg1->cons,Arg2->cons);
    }
    else{
      Res->cons = Arg1->cons;
    }
    Res->val.c = Res->cons;
    if(Res->cons == 1){
      switch(OP){
        case OP_ADD:
          Res->val.argval.i=Arg1->val.argval.i+Arg2->val.argval.i;
          break;
        case OP_SUB:
          Res->val.argval.i=Arg1->val.argval.i-Arg2->val.argval.i;
          break;
        case OP_MUL:
          Res->val.argval.i=Arg1->val.argval.i*Arg2->val.argval.i;
          break;
        case OP_DIV:
          Res->val.argval.i=Arg1->val.argval.i/Arg2->val.argval.i;
          break;
        case OP_MOD:
          Res->val.argval.i=Arg1->val.argval.i%Arg2->val.argval.i;
          break;
        case OP_MIN:
          Res->val.argval.i=-Arg1->val.argval.i;
          break;
        default:
          printf("*CASE NOT DEALT WITH\n");
      }
    }
    else{
      Res->val.argval.f=0;
      if(Arg1->cons == 1)
        Res->val.argval.f=Arg1->val.argval.i;
      else
        Res->val.argval.f=Arg1->val.argval.f;
      double tmp;
      if(Arg2->cons == 1)
        tmp=Arg2->val.argval.i;
      else
        tmp=Arg2->val.argval.f;
      switch(OP){
        case OP_ADD:
          Res->val.argval.f+=tmp;
          break;
        case OP_SUB:
          Res->val.argval.f-=tmp;
          break;
        case OP_MUL:
            Res->val.argval.f*=tmp;
          break;
        case OP_DIV:
          Res->val.argval.f/=tmp;
          break;
        case OP_MIN:
          Res->val.argval.f=-tmp;
          break;
        default:
          printf("CASE NOT DEALT WITH\n");
      }

    }
  }
  else{
    Res->cons= 0;
    Res->val.c = 0;
    Res->val.argval.var = getTemp();
    instrlist *list = new instrlist();
    instr * i;
    list->append(Arg1->code);
    if(Arg2)
    list->append(Arg2->code);
    if(OP==OP_MIN){
      i = instr::ic_1arg(OP,&Arg1->val,Res->val.argval.var);
    }
    else{
      i = instr::ic_2arg(OP,&Arg1->val,&Arg2->val,Res->val.argval.var);
    }
    list->addinstr(i);
    Res->code = list;
  }
}


