/*HEADER{{{
 * =============================================================
 *       Filename:  ic.h
 *        Created:  Friday 01 April 2011 05:49:47  IST
 *         Author:  Shitikanth (), shiti@iitk.ac.in
 *        Company:  IIT Kanpur
 * =============================================================
 }}} */
#ifndef INTERMEDIATE
#define INTERMEDIATE
#include <string>
#include <stdio.h>
#include "optimize.h"
#include "codegen.h"

using namespace std;

struct argumentValue {
  string var;
  int i;
  double f;
  argumentValue(string v,int in=0,double fl=0.0){
    var=v;
    i=in;
    f=fl;
  }
  argumentValue(int in=0,double fl=0.0){
    i=in;
    f=fl;
  }
};

class argument {
  public:
  	int c;
  	argumentValue argval;
  	void print();
    argument(int choice=1, argumentValue av=argumentValue()){
      c=choice;
      argval=av;
    }
};

extern argument * True;
extern argument * False;
extern argument * Zero;

argument * makearg(string var);
argument * makearg(int i);

enum opcode { OP_ADD, OP_SUB, OP_MIN, OP_MUL, OP_DIV, OP_MOD, OP_COPY, JUMP, CJUMP, LABEL, PARAM, CALL, OP_RETURN, ARRL, ARRR, RECL, RECR, OP_END, OP_PRINT, RUNT };

enum relation { R_L, R_LE, R_E, R_NE, R_G, R_GE, NONE };


class instr {

  opcode op;
  argument *arg1, *arg2;
  string result;
  string * label;
  instr * next;
  instr * prev;
  relation rel;
  
  public:
    instr(opcode o, string r="", argument *a1=NULL, argument *a2=NULL,  string * l=NULL, relation rel=NONE, instr * n=NULL, instr * p=NULL){
      op=o; arg1=a1; arg2=a2; result=r; label=l; this->rel=rel; next=n; prev=p;
    }
    void set_label(string l);
    void print();
    instr * getNext();
    static instr * ic_2arg  ( opcode o, argument * a1, argument * a2, string r);
    static instr * ic_1arg  ( opcode o, argument * a1, string r);
    static instr * ic_arrl  ( string r, argument * a1, argument * a2);
    static instr * ic_recl  ( string r, argument * a1, argument * a2);
    static instr * ic_label ( string l);
    static instr * ic_jump  ( string * l);
    static instr * ic_cjump ( relation r, argument * a1, argument * a2,  string * l);
    static instr * ic_call  ( string l);
    static void print       (relation r);

    friend class instrlist;
    friend class FGNode;
    friend class flowGraph;
    friend void interpret(instr *);
};

class instrlist {
  public:
  instr * head;
  instr * tail;
    instrlist(instr * h=NULL){
      head=h;
      tail=h;
    }
    void addinstr(instr *);
    void remove(instr *);       // Assume that the instruction is in the list
    void remove(instrlist *);   
    void append(instrlist *);   // Adds arg to the end of this list;
    void print();
};
#endif
