/*HEADER{{{
 * =============================================================
 *       Filename:  ic.cpp
 *        Created:  Sunday 03 April 2011 04:59:47  IST
 *         Author:  Shitikanth (), shiti@iitk.ac.in
 *        Company:  IIT Kanpur
 * =============================================================
 }}} */

#include "ic.h"
#include <string>
#include <stdio.h>
#include <assert.h>
using namespace std;

argument *True = new argument(1,argumentValue(1));
argument *False = new argument(1,argumentValue(0));
argument *Zero = new argument(1,argumentValue(0));
void argument::print(){
  switch(c){
    case 0: printf("%s",argval.var.c_str());
            break;
    case 1: printf("%d",argval.i);
            break;
    case 2: printf("%f",argval.f);
            break;
    default:
            fprintf(stderr,"CASE NOT DEALT WITH\n");
  }
}
argument * makearg(string var){
  argument * ans = new argument;
  ans->c=0;
  ans->argval.var=var;
  return ans;
}
argument * makearg(int i){
  argument * ans = new argument;
  ans->c=1;
  ans->argval.i=i;
  return ans;
}
void instr::set_label (string l){
  *label = l ;
}

void instr::print(){
  switch(op){
    case OP_ADD:
      printf("%s := ",result.c_str());
      arg1->print();
      printf(" + ");
      arg2->print();
      printf(";\n");
      break;
    case OP_SUB:
      printf("%s := ",result.c_str());
      arg1->print();
      printf(" - ");
      arg2->print();
      printf(";\n");
      break;
    case OP_MUL:
      printf("%s := ",result.c_str());
      arg1->print();
      printf(" * ");
      arg2->print();
      printf(";\n");
      break;
    case OP_MIN:
      printf("%s := - ",result.c_str());
      arg1->print();
      printf("\n");
      break;
    case LABEL:
      printf("%s: ",result.c_str());
      break;
    case JUMP:
      printf("JUMP %s;\n",(*label).c_str());
      break;
    case CJUMP:
      printf("IF ");
      arg1->print();
      print(rel);
      arg2->print();
      printf(" JUMP %s;\n",(*label).c_str());
      break;
    case OP_RETURN:
      printf("RETURN ");
      if(arg1)
        arg1->print();
      printf("\n");
      break;
    case PARAM:
      printf("PARAM ");
      arg1->print();
      printf("\n");
      break;
    case CALL:
      printf("CALL %s\n",(*label).c_str());
      break;
    case ARRR:
      printf("%s := ",result.c_str());
      arg1->print();
      printf("[ ");
      arg2->print();
      printf(" ];\n");
      break;
    case OP_END:
      printf("END\n");
      break;
    case OP_PRINT:
      printf("PRINT ");
      arg1->print();
      printf("\n");
      break;
    case ARRL:
      printf("%s [ ",result.c_str());
      arg1->print();
      printf(" ] := ");
      arg2->print();
      printf(";\n");
      break;

    case RECL:
      printf("%s.",result.c_str());
      arg1->print();
      printf(" := ");
      arg2->print();
      printf(";\n");
      break;

    case RECR:
      printf("%s := ",result.c_str());
      arg1->print();
      printf(".");
      arg2->print();
      printf(";\n");
      break;
    case RUNT:
      printf("GENERATE RUNTIME ERROR\n");
      break;
    case OP_COPY:
      arg1->print();
      printf(" := ");
      arg2->print();
      printf(";\n");
      break;
    default:
      printf("printing fn incomplete\n");
  }
}

instr * instr::getNext(){
  return next;
}
instr * instr::ic_2arg ( opcode o, argument * a1, argument * a2, string r){
  instr *temp = new instr(o,r,a1,a2);
  return temp;            
}

instr * instr::ic_1arg (opcode o, argument * a1, string r){
  instr *temp = new instr(o,r,a1);
  return temp;
}

instr * instr::ic_arrl ( string r, argument * a1, argument * a2){
  instr *temp = new instr(ARRL,r,a1,a2);
  return temp;
}

instr * instr::ic_recl ( string r, argument * a1, argument * a2){
  instr *temp = new instr(RECL,r,a1,a2);
  return temp;
}
instr * instr::ic_label( string l){
  instr * temp = new instr(LABEL,l);
  return temp;
}
instr * instr::ic_jump (string* l){
  instr *temp = new instr(JUMP,"",NULL,NULL,l);
  return temp;
}

instr * instr::ic_call (string l){
  string * l1 = new string (l);
  instr *temp = new instr(CALL,"",NULL,NULL,l1);
  return temp;
}

instr * instr::ic_cjump (relation r, argument * a1, argument * a2, string *l){
  instr * temp = new instr(CJUMP,"",a1,a2,l,r);
  return temp;
}

void instrlist::addinstr(instr *i){
  if (i==NULL) return;
  if(head==NULL){
    head= i;
    tail= i;
    head->prev=NULL;
    head->next=NULL;
    return;
  }
  assert(tail!=NULL);
  tail->next=i;
  i->prev=tail;
  tail=i;
}

void instrlist::remove(instr *i){
  assert(head!=NULL);
  assert(tail!=NULL);
  if(i->prev!=NULL){
    i->prev->next=i->next;
  }
  else{
    assert(head==i);
    head=i->next;
    head->prev=NULL;
  }
  if(i->next!=NULL){
    i->next->prev=i->prev;
  }
  else{
//    assert(tail==i);
    tail=i->prev;
    tail->next=NULL;
  }
}

void instrlist::remove(instrlist *list){
  assert(head!=NULL);
  assert(tail!=NULL);
  instr *h, *t;
  if(list==NULL || h==NULL)
    return;
  h = list->head;
  t = list->tail;
  if(h->prev!=NULL)
    h->prev->next=t->next;
  else
    head=t->next;
  if(t->next!=NULL)
    t->next->prev=h->prev;
  else
    tail=h->prev;
}

void instrlist::append(instrlist *ilist){
  if (ilist ==NULL) return;
  if (ilist->head==NULL) return;
  if (head == NULL){
    head = ilist->head;
    tail = ilist->tail;
    head->prev=NULL;
    return;
  }
  assert(tail!=NULL);
  tail->next=ilist->head;
  tail->next->prev=tail;
  tail=ilist->tail;
}

void instrlist::print(){
  instr * in = head;
  while(in!=NULL){
    in->print();
    in=in->next;
  }
}
void instr::print (relation r){
  switch(r){
    case R_L:
      printf(" < ");
      break;
    case R_LE:
      printf(" <= ");
      break;
    case R_E:
      printf(" = ");
      break;
    case R_NE:
      printf(" != ");
      break;
    case R_G:
      printf(" > ");
      break;
    case R_GE:
      printf(" >= ");
      break;
    case NONE:
      printf(" NONE ");
      break;
    default:
      printf("The world is about to break down. Run for life!!\n");
  }
}


