/*HEADER{{{
 * =============================================================
 *       Filename:  codegen.cpp
 *        Created:  Monday 11 April 2011 03:11:52  IST
 *         Author:  Shitikanth (), shiti@iitk.ac.in
 *        Company:  IIT Kanpur
 * =============================================================
 }}} */

#include "codegen.h"
#include "scope.h"
#include "debug.h"
#include "ic.h"
#include "reg.h"
#include <string>
#include <cstdarg>
#include <cassert>

using namespace std;

char stackPointer[] = "$sp";
RegisterHandler regManager;
map <string, string> labelToFunc;
int paramCount=0;
set<instr *> leaders;
Scope * Env;

extern FILE * of;

void variable(string s);
Register * getRegister(string s="",bool flag=true);

struct cgvalue{
  int type;
  int i;
  double f;
  Register * r;
};

cgvalue * makevalue(argument * arg){
  cgvalue * ans = new cgvalue;
  switch(arg->c){
    case 0:
      ans->type=0;
      if(arg->argval.var=="_RV")
        ans->r=regManager.v;
      else
        ans->r=getRegister(arg->argval.var);
      break;
    case 1:
      ans->type=1;
      ans->i=arg->argval.i;
      break;
    case 2:
      ans->type=2;
      ans->f=arg->argval.f;
      break;
  }
  return ans;
}
/*
 * Wrapper to print MIPS code to output file
 */
// void code (const char *s, ...); {{{
void code (const char *s, ...){
  va_list arguments;
  va_start(arguments,s);
  vfprintf(of,s,arguments);
  va_end(arguments);
}

void syscall(int a){
  code("\tli $v0, %d\n",a);
  code("\tsyscall\n");
}

void newline(){
  code ("\tla $a0, newline\n");
  syscall(4);
}

void code (Register *reg){
  code("%s",reg->getName().c_str());
}

void code (cgvalue * val){
  switch(val->type){
    case 0: code(val->r);
            break;
    case 1: code("%d",val->i);
            break;
    case 2: code("%f",val->f);
  }
}
// }}}


void decrementStackPointer(int a){ 
  code("\tsubu $sp, $sp, %d\n",a);
}


void createLabel(string s){
  code("%s:\n",s.c_str());
}

void createExit(){
  syscall(10);
  code("\n.data\n");
  code("newline:\t .asciiz \"\\n\"; \n");
  code("runtime:\t .asciiz \"Runtime error: array index out of bound\\n\"; \n");
}

void initialize(){
  code(".text\n");
  createLabel("main");
}

/* 
   void variable(string res){
   Register * reg;
   if(res=="_RV")
   code("$v0");
   else{
   reg=getRegister(res);
   Entry * e = Env->lookup(res);
   if(e->type==basicType[tINTEGER]){
   reg=getRegister(res);
   }
   else if(e->type==basicType[tREAL]){
   reg=regManager.getFloRegister(res);
   }
// add map of this variable to reg in varToReg
code(reg);
}
}
*/
//
// If argument is constant, load it into a register
// and return the register. Otherwise, return the
// register containing the variable. Load the variable into 
// the register if needed.
//
Register * firstArg(argument * arg){
  Register * reg;
  switch(arg->c){
    case 0:
      reg=getRegister(arg->argval.var);
      break;
    case 1:
      reg=regManager.getGenRegister();
      code("\tli ");
      code(reg);
      code(", ");
      code(makevalue(arg));
      code("\n");
      break;
    case 2:
      reg=regManager.getFloRegister();
      code("\tli.s ");
      code(reg);
      code(", ");
      code(makevalue(arg));
      code("\n");
      break;
    default:
      debug("This should not happen!\n");
  }
  return reg;
}


void cg2arg(const char * op, string res, argument * arg1, argument * arg2){
  Register * r1;
  r1=getRegister(res);
  Register * a1 = firstArg(arg1);
  cgvalue * a2 = makevalue(arg2);
  code("\t%s ",op);
  code(r1);
  code(", ");
  code(a1);
  code(", ");
  code(a2);
  code("\n");
}

void cgCopy(argument * arg1, argument * arg2){
  Register * r1;
  cgvalue * val;
  r1= getRegister(arg1->argval.var,false);
  val=makevalue(arg2);
  switch(arg2->c){
    case 0:
      code("\tmove ");
      code(r1);
      code(", ");
      code(val);
      code("\n");
      break;
    case 1:
      code("\tli ");
      code(r1);
      code(", ");
      code(val);
      code("\n");
      break;
  }
}

void cgCond(relation r, argument * arg1, argument * arg2, string label){
  Register * a1 = firstArg(arg1);
  cgvalue * val = makevalue(arg2);
  switch(r){
    case R_L:
      code("\tblt ");
      break;
    case R_LE:
      code("\tble ");
      break;
    case R_E:
      code("\tbeq ");
      break;
    case R_NE:
      code("\tbne ");
      break;
    case R_G:
      code("\tbgt ");
      break;
    case R_GE:
      code("\tbge ");
      break;
  }
  code(a1);
  code(", ");
  code(val);
  code(", %s\n",label.c_str());
}

Register * getRegister(string s, bool flag){
  Register *r = regManager.getGenRegister(s);
  if(flag){
    if(!r->loaded){
      size_t found =s.find("_TEMP");
      if((int)found==0){
        //temp var
        r->loaded=true;
      }
      else{
        //local variable
        int np = Env->depth-1;
        Entry * e = Env->lookup(s);
        if(e){
          int nq = e->depth-1;
          if (np<nq){
            assert(false);
          }
          else{
            int hops= np-nq;
            code("\tmove $a0, $fp\n");
            while(hops>0){
              code("\tlw $a0, ($a0)\n");
              hops--;
            }
          }

          code("\tlw ");
          code(regManager.varToReg[s]);
          code(", %d($a0)\n",-(e->offset));
        }
        r->loaded=true;
      }
    }
  }
  else{
    r->loaded=true;
  }
  return r;
}


void interpret(instr * in){
  switch(in->op){
    case OP_PRINT:
      {
        Register *r1 = firstArg(in->arg1);
        code ("\tmove $a0,");
        code (r1);
        code ("\n");
        syscall(1);
        newline();
        break;
      } 
    case OP_ADD:
      cg2arg("add",in->result,in->arg1,in->arg2);
      break;
    case OP_SUB:
      cg2arg("sub",in->result,in->arg1,in->arg2);
      break;
    case OP_MIN:
    {
      Register * r1;
      r1 = getRegister(in->result);
      cgvalue * a2= makevalue(in->arg1);
      code("\tsub ");
      code(r1);
      code(", $0, ");
      code(a2);
      code("\n");
      break;
    }
    case OP_MUL:
      cg2arg("mul",in->result,in->arg1,in->arg2);
      break;
    case OP_DIV:
      cg2arg("div",in->result,in->arg1,in->arg2);
      break;
    case OP_MOD:
      break;
    case OP_COPY:
      cgCopy(in->arg1,in->arg2);
      break;
    case JUMP:
      code("\tb %s\n",(*(in->label)).c_str());
      break;
    case CJUMP:
      cgCond(in->rel, in->arg1, in->arg2, *(in->label));
      break;
    case RUNT:
      code("\tla $a0, runtime\n");
      syscall(4);
      break;
    case LABEL:
      {
        code("\n%s:\n",in->result.c_str());
        size_t found=in->result.find("_FUNCTION");
        if((int)found==0){
          string name = labelToFunc[in->result];
          Scope *next = Env->lookup(name)->nextenv;
          Env=next;
          code("\tsubu $sp, $sp, %d\n",12+Env->getOffset());
          code("\tsw $ra, %d($sp)\n",8+Env->getOffset());
          code("\tsw $fp, %d($sp)\n",4+Env->getOffset());
          code("\taddu $fp, $sp, %d\n",Env->getOffset());
          //Access link will be in ($fp)
        }
        break;
      }
    case PARAM:
      {
        Register *r1=firstArg(in->arg1);
        code("\tsubu $sp, $sp, 4\n");
        code("\tsw ");
        code(r1);
        code(", ($sp)\n");
        paramCount++;
        break;
      }
    case CALL:
      {
        int np, nq; // p - callee, q- caller
        nq = Env->depth-1;
        np = Env->lookup(labelToFunc[*(in->label)])->depth;
        if(np > nq){
          assert(np==nq+1); // if np > nq, we must have np=nq+1
          code("\tsw $fp, -12($sp)\n");
        }
        else{
          int hops= nq-np;
          code("\tlw $a0, ($fp)\n");
          while(hops--){
            code("\tlw $a0, ($a0)\n");
          }
          code("\tsw $a0, -12($sp)\n");
        }
        regManager.cleanTable(Env);

        code("\tjal %s\n", (*(in->label)).c_str());
        while(paramCount!=0){
          code("\taddu $sp, $sp, 4\n");
          paramCount--;
        }
        break;
      }
    case OP_RETURN:
      if(in->arg1){
        cgvalue * val=makevalue(in->arg1);
        if(in->arg1->c==1){
          code("\tli $v0, ");
        }
        else
          code("\tmove $v0, ");
        code(val);
        code("\n");
      }

      regManager.cleanTable(Env);
      code("\tlw $ra, %d($sp)\n",8+Env->getOffset());
      code("\tlw $fp, %d($sp)\n",4+Env->getOffset());
      code("\taddu $sp, $sp, %d\n",12+Env->getOffset());
      code("\tjr $ra\n\n");
      break;
    case ARRL:
      {
        //result[arg1]:=arg2
        Entry * e = Env->lookup(in->result);
        Register * a1 = firstArg(in->arg1);
        code("\tmove $a0, %s\n",a1->getName().c_str());
        // get actual address in a1
        code("\tmul $a0, $a0, ");
        code("%d\n",e->type->child[0]->width);
        code("\taddu $a0, $fp, $a0\n");
        code("\tsub $a0, $a0");
        code(", %d\n",e->offset);
        code("\n");

        // save variable to address
        Register *a2 = firstArg(in->arg2);
        code("\tsw ");
        code(a2);
        code(", ($a0)\n");

        break;

      }
    case ARRR:
      {
        Entry * e = Env->lookup(in->arg1->argval.var);
        Register * a1 = firstArg(in->arg2);
        
        code("\tmove $a0, %s\n",a1->getName().c_str());
        // get actual address in a0
        code("\tmul $a0, $a0, ");
        code("%d\n",e->type->child[0]->width);
        code("\taddu $a0, $fp, $a0\n");
        code("\tsub $a0, $a0");
        code(", %d\n",e->offset);
        code("\n");
        // load variable from address
        Register * r1 = getRegister(in->result);
        code ("\tlw ");
        code (r1);
        code (", ");
        code ("($a0)\n");
        break;
      }
    case RECL:
      {
        Entry * e1 = Env->lookup(in->result);
        Entry * e2 = e1->nextenv->lookup(in->arg1->argval.var);
        Register * a1 = firstArg(in->arg2);
        code("\tsw %s, %d($fp)\n",a1->getName().c_str(),e1->offset+e2->offset);
        break;
      }
    case RECR:
      {
        Entry * e1 = Env->lookup(in->arg1->argval.var);
        Entry * e2 = e1->nextenv->lookup(in->arg2->argval.var);
        // load variable from address
        Register * r1 = getRegister(in->result);
        code ("\tlw ");
        code (r1);
        code (", %d($fp)\n",e1->offset+e2->offset);
        break;
      }
      break;
    case OP_END:
      Env = Env->getPrev();
      break;
    default:
      error("This shouldn't be happening!\n");
  }
}

void codegen(instrlist * list,Scope * symtab){ 
  Env=symtab;
  initialize();
  if((!list)||(!(list->head)))
    return;  
  code("\tmove $fp, $sp \n");
  decrementStackPointer(Env->getOffset());
  instr * cur;
  cur=list->head;
  while(cur){
    interpret(cur);
    cur=cur->getNext();
  }
  createExit();

}

