%{
//Include files{{{
#define FLAG
#include "src/type.h"
#include <stdio.h>
#include <string>
#include <cstring>
#include <queue>
#include <stack>
#include <utility>
#include <algorithm>
#include <cassert>
#include "src/debug.h"
#include "src/scope.h"
#include "src/ic.h"
#include "src/icgen.h"
#include "src/codegen.h"
#include "src/optimize.h"
using namespace std;
//}}}
//Lex stuff{{{
extern "C"{
  int yylex(void);
  int yyparse(void);
  int yywrap() { return 1; }
}

extern char *yytext;
extern int yylineno;

int yyerror(char *msg)
{
  printf("%s at line %d with [%s]\n",msg,yylineno,yytext);
}

int yyerror(const char *msg){
  yyerror((char *) msg);
}
//}}}
// Global variables{{{
Scope *env;                                                 // current environment
stack<queue<string> > identLists;                           // global list of identifiers
queue<pair<string, TypeSpecifier *> > params;               // global list of parameters
extern argument *True, *False, *Zero;
extern int tempCount;
extern int labelCount;
extern int funcCount;
extern int depth;
extern map<string,string> labelToFunc;
stack <TypeSpecifier *> expectedType;                       // for procedure and array calls
stack <TypeSpecifier *> returnType;                         // for nested procedure declarations
stack <TypeSpecifier *> designatorType;                     // for types of designators
stack <Scope *> envStack;                                   // for records
stack <desigvar> designatorVar;                             // for var of designators 
stack <string> suffixArg;                                   // for storing name of variable on which to apply optSuffix
bool typeCheck = false;
bool printLeaders = false;
bool printIC = false;
bool showOpt = false;
extern int depth;
string st;
FILE * of;
//}}}
%}
/* Union {{{ */
%union{
  char * str;
  TypeSpecifier * typ;
  Node * node;
  NodeList * nodelist;                                       //For expression list
  ConstList * conslist;
  ConstE cons;
  }
/*}}}*/
/* List of tokens {{{*/
%token ARRAY     
%token IMPORT    	 
%token RETURN
%token BBEGIN    
%token IN        	 
%token THEN
%token BY        
%token IS        	 
%token TO
%token CASE      
%token LOOP      	 
%token TYPE
%token CONST     
%token MOD       	 
%token UNTIL
%token DIV       
%token MODULE   	 
%token VAR
%token DO        
%token NIL       	 
%token WHILE
%token ELSE      
%token OF        	 
%token WITH
%token ELSIF     
%token OR
%token END       
%token POINTER
%token TRUE
%token FALSE
%token EXIT      
%token PROCEDURE
%token FOR
%token PRINT
%token RECORD
%token IF        
%token REPEAT
%token ASSIGN LE GE DOTS 
%token CONSTchar CONSTstring 
%token <str> CONSTnum CONSTreal
%token <str> ident
/*}}}*/
/* Associativity, precedence and type {{{ */
%nonassoc '='  '#'  '<'  LE  '>'  GE  IN  IS
%left '+'  '-'  OR
%left '*'  '/'  DIV  MOD  '&'
%nonassoc UPLUS UMINUS
%type <str> IdentDef Qualident
%type <typ> Type 
%type <node> Expr Factor Statement StatementSeq ElseIfBlock Else StatBlock
%type <node> optSuffix Designator ProcDecl DeclSeq ProcList Module
%type <nodelist> ExprList 
%type <cons> ConstExpr
%type <conslist> ConstExprList
/*}}}*/
%%

Module: 
	MODULE ident ';' ImportList DeclSeq StatBlock END ident '.'
                {
                  printf("\n");
                  $$ = new Node;
                  instrlist * list = new instrlist;
                  list->append($6->code);
                  instr * in;
                  in = instr::ic_jump(new string("_EXIT"));
                  list->addinstr(in);
                  list->append($5->code);
                  in = instr::ic_label("_RUNTIME");
                  list->addinstr(in);
                  in = instr::ic_1arg(RUNT,NULL,"");
                  list->addinstr(in);
                  in = instr::ic_label("_EXIT");
                  list->addinstr(in);
                  if(!typeCheck){
                    $$->code=list;
                    if(showOpt)
                      $$->code->print();
                    flowGraph fg= flowGraph::generateFG($$->code);
                    if(printLeaders)
                      fg.printLeaders();
                    if(showOpt){
                      printf("\n");
                      printf("\n");
                    }
                    // $$->code->print();
                    flowGraph::deadCodeRemoval(fg,$$->code);
                    // printf("\n");
                    // printf("\n");
                    if(showOpt||printIC)
                        $$->code->print();
                    printf("\n");
                    //printf("\n");
                    //env->showAll();
                    codegen($$->code,env);
                  }
                }
	;

ImportList: 
	IMPORT ImportListTemp ';'
	|
	;

ImportListTemp: 
 	ImportListTemp ',' Import  
	| Import
	;

Import:
	ident ASSIGN ident
	| ident
	;

StatBlock:
	BBEGIN StatementSeq 
                        {
                          $$ = new Node();
                          string l = newLabel();
                          backpatch($2->Next,l);
                          instrlist * list = new instrlist();
                          list->append($2->code);
                          instr * i = instr::ic_label(l);
                          list->addinstr(i);
                          $$->code=list;
                        }
	|
                        {
                          $$ = new Node;
                          $$->code = new instrlist;
                        }
	;

DeclSeq: 
  DataList
  ProcList  
            {
              $$ = $2;
            }
;

DataList:
  CONST ConstList DataList 
            { 
              //Not Implemented; 
            }
| TYPE  TypeList  DataList
| VAR   VarList DataList
|
;

ConstList :
  IdentDef '=' ConstExpr ';' ConstList
| 
;

TypeList : 
  IdentDef '=' Type ';'
                    {
                      printf("Add type %s\n",$1);
                      if(!env->insertType(string($1),$3))
                        fprintf(stderr,"error: Redeclaration of %s\n",$1);                        
                    }
  TypeList
|
;

VarList  :          
                    {
                      identLists.push(queue<string>());
                    }
  IdentDefList 
  ':' Type ';'      { 
                      string st;
                      while(!identLists.top().empty()){
                        st=identLists.top().front();
                        debug("Declare variable %s.\n",st.c_str());
                        if(!env->declare(string(st),$4))
                          fprintf(stderr,"error: Redeclaration of %s\n",st.c_str());
                        identLists.top().pop();
                      }
                      identLists.pop();
                    }
                        
  VarList
| 
;

ProcList     :
  ProcDecl ';' ProcList
               {
                 $$= new Node;
                 $$->code = new instrlist;
                 $$->code->append($1->code);
                 $$->code->append($3->code);
               }
| ForwardDecl ';' ProcList
                {
                  $$ = new Node;
                }
|
                {
                  $$ = new Node;
                  $$->code = new instrlist;
                }
;


ProcDecl     : 
  PROCEDURE         
  Receiver          
  IdentDef          
  FormalPars ';'    
                    { 
                      Entry * e = env->localLookup($3);
                      TypeSpecifier * t;
                      if(e!=NULL){
                        fprintf(stderr,"error %d: %s is declared already.\n",yylineno, $3);
                        t=basicType[tERROR];
                        returnType.push(basicType[tERROR]);
                      }
                      else{
                        env = new Scope(env);
                        t=new TypeSpecifier(tPROCEDURE);
                        t->n=params.size();
                        t->child=new TypeSpecifier *[t->n];
                        
                        stack<pair<string, TypeSpecifier *> > revParams;
                        for(int j=0; j<t->n-1; j++){
                            revParams.push(params.front());
                            params.pop();
                        }
                        int i=t->n-1;
                        depth++;
                        while(i>0){
                          t->child[i--]=revParams.top().second;
                          env->paramDeclare(revParams.top().first,revParams.top().second);
                          revParams.pop();
                        }
                        t->child[0]=params.front().second;
                        returnType.push(t->child[0]);
                        depth--;
                        env->getPrev()->declare(string($3),t,env);
                        depth++;
                        string temp=newFunction(); 
                        env->lookup($3)->label=temp;
                        labelToFunc[temp]=string($3);
                        debug("added to labelFunc %s, %s\n",temp.c_str(),$3);
                      }

                      int i=1;
                      debug("Start procedure declaration- %s().\n",$3);
                        params.pop();
                    }
  DeclSeq StatBlock
  END ident         
                    {
                      returnType.pop();
                      if(strcmp($3,$10)!=0)
                        printf("error %d: Expected %s after END: found %s\n",yylineno,$3,$10);
                      Scope * prev = env->getPrev();
                      debug("Close procedure declaration- %s().\n",$3);
                      env = prev;
                      Entry * e = env->lookup($3);
                      $$ = new Node;
                      instrlist * list = new instrlist;
                      instr * in;
                      in = instr::ic_label(e->label);
                      list->addinstr(in);
                      list->append($8->code);
                      list->append($7->code);
                      in = instr::ic_1arg(OP_END,NULL,"");
                      list->addinstr(in);
                      $$->code=list;
                      depth--;
                    }
;

ForwardDecl :
  PROCEDURE '^' Receiver IdentDef FormalPars
;


FormalPars: 
  '(' FPsectionList ')' ':' Qualident 
                        {
                          Entry * e=env->lookup($5);
                          if(e==NULL)
                            fprintf(stderr,"error: %s is not declared.\n",$5);
                          else if(e->type->node!=-1)
                            fprintf(stderr,"error: %s is not a type.\n",$5);
                          else{
                           params.push(make_pair("",(TypeSpecifier *)e->type->child[0]));
                          }
                        }
| '(' ')' ':' Qualident
						{
						  Entry * e=env->lookup($4);
                          if(e==NULL)
                            fprintf(stderr,"error: %s is not declared.\n",$4);
                          else if(e->type->node!=-1)
                            fprintf(stderr,"error: %s is not a type.\n",$4);
                          else{
                           params.push(make_pair("",(TypeSpecifier *)e->type->child[0]));
                          }	
						}
| '(' FPsectionList ')'
                        {
                          params.push(make_pair("",basicType[8]));
                        }
|  '(' ')'
                        {
                          params.push(make_pair("",basicType[8]));
                        }
|               
                        {
                          params.push(make_pair("",basicType[8]));
                        }
;

FPsectionList:
  FPsection ';' FPsectionList
| FPsection
;

FPsection:
            
                        {
                          identLists.push(queue<string>());
                        }
  IdentList ':' Type

                        {
                          string s;
                          while(!identLists.top().empty()){
                            s=identLists.top().front();
                            identLists.top().pop();
                            params.push(make_pair(s,$4));
                          }
                          identLists.pop();
                        }
| VAR 
                        {
                          identLists.push(queue<string>());
                        }
  IdentList ':' Type
                        {
                          string s;
                          while(!identLists.top().empty()){
                            s=identLists.top().front();
                            identLists.top().pop();
                            params.push(make_pair(s,$5));
                          }
                          identLists.pop();
                        }
;

IdentList:
  ident ','             {
                          identLists.top().push($1);
                        }
  IdentList
| ident                 {
                          identLists.top().push($1);
                        }
;

Receiver:
  '(' ident ':' ident ')' 
| '(' VAR ident ':' ident ')'
| 
;

Type: 
  Qualident              
                        { 
                          Entry * smt; 
                          $$ = NULL;
                          smt = env->lookup(string($1)); 
                          if(smt==NULL){
                            fprintf(stderr,"error: %s not declared.\n",$1);
                          }
                          else if(smt->type->node==-1){
                            $$ = (TypeSpecifier *) (smt->type->child[0]);
                          }
                          else{
                            fprintf(stderr,"%s is not a declared Type.\n",$1);
                          }
                        }
| ARRAY ConstExprList OF Type 
                        { $$ = new TypeSpecifier();
                          if(!$2->error){
                            $$->node = tARRAY;
                            $$->child = new TypeSpecifier *[1];
                            $$->child[0] = $4;
                            $$->n = $2->size;
                            $$->dimns = new int[$$->n];
                            $$->width = $$->n*4;
                            int temp=1;
                            ConstList * l=$2;
                            int i=0;
                            if(l==NULL) temp=0;
                            while(l!=NULL){
                              $$->dimns[i]=l->head.val;
                              temp*=$$->dimns[i++];
                              l=l->tail;
                            }
                            $$->width += temp*$$->child[0]->width;
                          }
                        }
| ARRAY               OF Type 
                        { //Dynamic Array implement if time permits
                          $$ = new TypeSpecifier();
                          $$->node = tARRAY;
                          $$->n = 1;
                          $$->child = new TypeSpecifier *[1];
                          $$->child[0] = $3;
                        }
| RECORD '('Qualident')' FieldList END
                        {
						   //Extension of Record if time permits
                           $$=NULL;
                        }
| RECORD
                        {
                          env = new Scope(env);
                        }
  FieldList END
                        {
                          $$= new TypeSpecifier();
                          $$->node = tRECORD;
                          $$->rectab = env;
                          $$->width = env->getOffset();
                          Scope * prev = env->getPrev();
                          env->setPrev(NULL);
                          env=prev;
                        }
| POINTER TO Type
                        {
                          $$ = new TypeSpecifier(tPOINTER);
                          $$->n = 1;
                          $$->child = new TypeSpecifier *[1];
                          $$->child[0] = $3;
                          $$->width=4;
                        }
| PROCEDURE FormalPars
                        {
                          $$=new TypeSpecifier(tPROCEDURE);
                          $$->n=params.size();
                          $$->child=new TypeSpecifier *[$$->n];
                          int i=1;
                          while(i<$$->n){
                            $$->child[i++]=params.front().second;
                            params.pop();
                          }
                          $$->child[0]=params.front().second;
                          params.pop();
                        }
;

ConstExprList :
  ConstExpr ',' ConstExprList
                        {
                          $$ = new ConstList;
                          if($1.error||$3->error){
                            $$->error=true;
                          }
                          else{
                            $$->head=$1;
                            $$->tail=$3;
                            $$->error=false;
                            $$->size=$3->size+1;
                          }
                        }
| ConstExpr             
                        {
                          $$ = new ConstList;
                          if($1.error)
                            $$->error=true;
                          else{
                            $$->error=false;
                            $$->head=$1;
                            $$->tail=NULL;
                            $$->size=1;
                          }
                        }
;

FieldList    :
  M IdentDefList 
  ':' Type ';'
                        {
                          //TODO insert error in declare 
                          while(!identLists.top().empty()){
                            env->declare(identLists.top().front(),$4);
                            identLists.top().pop();
                          }
                          identLists.pop();
                        }
  FieldList
| M
  IdentDefList 
  ':' Type
                        {
                          while(!identLists.top().empty()){
                            env->declare(identLists.top().front(),$4);
                            identLists.top().pop();
                          }
                          identLists.pop();
                        }
|
;

M :
                        {
                          identLists.push(queue<string>());
                        }
;

StatementSeq : 
  Statement ';' StatementSeq
                        {
                          $$ = new Node;
                          instrlist * list = new instrlist;
                          list->append($1->code); 
                          instr * i;
                          string l = newLabel();
                          i = instr::ic_label(l);
                          list->addinstr(i);
                          list->append($3->code);
                          $$->code=list;
                          $$->Next=$3->Next;
                          backpatch($1->Next,l);
                        }
| Statement             
                        {
                            $$ = $1;
                        }
;

Statement    : 
Designator ASSIGN Expr 
                        { 
                          $$ = new Node;
                          if($3->type!=basicType[tERROR]&&$1->type!=basicType[tERROR]){
                            if(!TypeExpandable($1->type,$3->type)){
                                typeError(0,$3->type,$1->type,yylineno);
                                $$->type=basicType[tERROR];
                            }
                            else
                              $$->type=basicType[tVOID];
                          }
                          else
                            $$->type=basicType[tERROR];

                          //TODO Case of boolean expressions
                          instr * i;
                          instrlist * list = new instrlist;
                          list->append($3->code);
                          if($$->type==basicType[tVOID]){
                            if($3->cons==3){
                              if($3->type==basicType[tBOOLEAN]){
                                string s1=newLabel();
                                string s2=newLabel();
                                backpatch($3->False,s1);
                                backpatch($3->True,s2);
                                i = instr::ic_label(s1);
                                list->addinstr(i);
                                i = instr::ic_2arg(OP_COPY,&$1->val,False,"");
                                list->addinstr(i);
                                string ** st = new string *;
                                *st = new string;
                                i = instr::ic_jump(*st);
                                list->addinstr(i);
                                $$->Next.push_back(*st);

                                i = instr::ic_label(s2);
                                list->addinstr(i);
                                i = instr::ic_2arg(OP_COPY,&$1->val,True,"");
                                list->addinstr(i);
                              }
                            }
                            else{
                            }
                            switch($1->dv.dclass){
                              case 0:
                                i = instr::ic_2arg(OP_COPY,makearg($1->dv.var),&$3->val,"");
                                list->addinstr(i);
                                break;
                              case 1:
                                i = instr::ic_arrl($1->dv.var,$1->dv.arg,&$3->val); 
                                list->addinstr(i);
                                break;
                              case 2:
                                i = instr::ic_recl($1->dv.var,$1->dv.arg,&$3->val); 
                                list->addinstr(i);
                                break;
                              default:
                                assert(false);
                            }
                            $$->code = $1->code;
                            $$->code->append(list);
                          }
                        }
                         
                         
| Designator            
                        /* Note that we have made some changes from the original Oberon-2 grammar 
                        to make it unambiguous and to allow designator expressions to include return values from 
                        functions with more than one parameters. */
            
| IF Expr   
  THEN StatementSeq ElseIfBlock Else END 
                        {  
                          if($2->type != basicType[tERROR]){
                            if ($2->type != basicType[tBOOLEAN]){
                              fprintf(stderr,"condition in IF should be boolean.\n");
                            }
                          }

                          if($2->type==basicType[tBOOLEAN]){

                            $$=new Node;
                            instr * i;
                            string ** st = new string *;
                            *st = new string;

                            string l1=newLabel();
                            string l2=newLabel();
                            string l3=newLabel();

                            backpatch($2->True,l1);
                            backpatch($2->False,l2);

                            merge($$->Next,$4->Next);
                            merge($$->Next,$5->Next);
                            merge($$->Next,$6->Next);
                            $$->Next.push_back(*st);

                            instrlist * list = new instrlist;
                            list->append($2->code);
                            i =instr::ic_label(l1);
                            list->addinstr(i);
                            list->append($4->code);

                            i =instr::ic_jump(*st);
                            list->addinstr(i);

                            i =instr::ic_label(l2);
                            list->addinstr(i);
                            list->append($5->code);

                            i =instr::ic_label(l3);
                            list->addinstr(i);
                            list->append($6->code);

                            $$->code=list;

                          }
                        }

| CASE Expr OF CaseList Else END 
                        {
                           $$ = new Node;
                          /*
                          Syntactic sugar. To be implemented if time permits. 
                          */
                        }

| WHILE Expr 
  DO StatementSeq END  
                         { 
                           $$ = new Node;
                           if($2->type != basicType[tERROR]){
                             if ($2->type != basicType[tBOOLEAN]){
                               $$->type = basicType[tERROR];
                               fprintf(stderr,"condition in WHILE should be boolean.\n");
                             }
                             else
                               $$->type = basicType[tVOID];
                           }
                           else{
                             $$->type = basicType[tERROR];
                           }

                           if($$->type==basicType[tVOID]){
                             string **l1, l2;
                             l1 = new string *;
                             *l1 = new string;
                             **l1 = newLabel();
                             l2 = newLabel();
                             backpatch($2->True,l2);
                             backpatch($4->Next,**l1);
                             merge($$->Next,$2->False);

                             instrlist * list = new instrlist;
                             instr * i;
                             i = instr::ic_label(**l1);
                             list->addinstr(i);
                             list->append($2->code);
                             i = instr::ic_label(l2);
                             list->addinstr(i);
                             list->append($4->code);
                             i = instr::ic_jump(*l1);
                             list->addinstr(i);

                             $$->code=list;
                           }
                         }

| REPEAT StatementSeq UNTIL Expr 
                        { 
                          $$ = new Node;
                          if($4->type != basicType[tERROR]){
                             if ($4->type != basicType[tBOOLEAN]){
                               $$->type = basicType[tERROR];
                               fprintf(stderr,"condition in WHILE should be boolean.\n");
                             }
                             else
                               $$->type = basicType[tVOID];
                           }
                           else{
                             $$->type = basicType[tERROR];
                           }

                           if($$->type == basicType[tVOID]){

                             string l1, l2;
                             l1 = newLabel();
                             l2 = newLabel();

                             backpatch($4->False,l1);
                             backpatch($2->Next,l2);
                             merge($$->Next,$4->True);

                             instrlist * list = new instrlist;
                             instr * i;
                             i = instr::ic_label(l1);
                             list->addinstr(i);
                             list->append($2->code);
                             i = instr::ic_label(l2);
                             list->addinstr(i);
                             list->append($4->code);

                             $$->code = list;
                           }

                        }

| FOR ident ASSIGN Expr TO Expr BY ConstExpr
   DO StatementSeq END 
								{
                                    $$ = new Node;
									Entry * smt; 
								    //$$ = NULL;
								    smt = env->lookup(string($2)); 
								    if(smt==NULL){
									 fprintf(stderr,"error: %s not declared.\n",$2);
								    }
								    else if(smt->type->node==-1){
									 fprintf(stderr,"%s is  a declared Type.\n",$2);                        
								    }
								    else{
									    if (isArithComparable($4->type,$6->type) //&& isArithComparable($6,$8) 
											&& CheckEquivalence(smt->type,$4->type));
										//$$ = basicType[tVOID];
									    else ;
										//$$ = basicType[tERROR];
								    }
								}


| FOR ident ASSIGN Expr TO Expr 
  DO StatementSeq END 
                        {
                          $$ = new Node;
                          Entry * smt; 
                          //$$ = NULL;
                          printf("Check %s\n",$2);
                          smt = env->lookup(string($2)); 
                          if(smt==NULL){
                            fprintf(stderr,"error: %s not declared.\n",$2);
                          }
                          else if(smt->type->node==-1){
                            fprintf(stderr,"%s is  a declared Type.\n",$2);                        
                          }
                          else{
                            if (isArithComparable($4->type,$6->type) //&& isArithComparable($6,$8) 
                                && CheckEquivalence(smt->type,$4->type));
                            //$$ = basicType[tVOID];
                            else ;
                            //$$ = basicType[tERROR];
                          }
					    }


| LOOP StatementSeq END
                        {
                           $$ = new Node;
                        }
| WITH GuardStatList Else END
                        {
                           $$ = new Node;
                        }

| EXIT 
                        {
                           $$ = new Node;
                        }
| PRINT ident
                        {
                           $$ = new Node;
                           instrlist * list = new instrlist;
                           instr * in;
                           in = instr::ic_1arg(OP_PRINT,makearg($2),"");
                           list->addinstr(in);
                           $$->code=list;   
                        }
| RETURN Expr
                                {
                                  $$ = new Node;
                                  $$->type = basicType[tVOID];
                                  if(returnType.size()==0){
                                    fprintf(stderr,"error at line %d: Cant return here.\n",yylineno);
                                    $$->type = basicType[tERROR];
                                  }
                                  else if($2->type!=basicType[tERROR]&&returnType.top()!=basicType[tERROR]){
                                    if(!CheckEquivalence(returnType.top(),$2->type)){
                                      fprintf(stderr,"Invalid return type.\n");
                                      typeError(0,$2->type,returnType.top(),yylineno);
                                      $$->type = basicType[tERROR];
                                    }
                                  }
                                  if(returnType.top()==basicType[tERROR])
                                    $$->type = basicType[tERROR];
                                  if($$->type==basicType[tVOID]){
                                    instrlist * list = new instrlist;
                                    instr * in;
                                    list->append($2->code);
                                    in = instr::ic_1arg(OP_RETURN,&$2->val,"");
                                    list->addinstr(in);
                                    $$->code=list;
                                  }
                                  else{
                                    $$->code=new instrlist;
                                  }
                                }
| RETURN						
                        {
                          $$ = new Node;
                          if(returnType.size()==0){
                            fprintf(stderr,"error at line %d: Cant return here.\n",yylineno);
                          }
                          else if(returnType.top()!=basicType[tERROR]){
                            if(!CheckEquivalence(returnType.top(),basicType[tVOID])){
                              fprintf(stderr,"Invalid return type.\n");
                              typeError(0,basicType[tVOID],returnType.top(),yylineno);
                            }
                          }

                          instrlist * list;
                          instr * in;
                          in = instr::ic_1arg(OP_RETURN,NULL,"");
                          list = new instrlist;
                          list->addinstr(in);
                          $$->code=list;
                        }
|
                        {
                           $$ = new Node();
                        }
;

ElseIfBlock:
  ELSIF Expr THEN StatementSeq ElseIfBlock
                        {
                          if($2->type != basicType[tERROR]){
                            if ($2->type != basicType[tBOOLEAN]){
                              fprintf(stderr,"condition in IF should be boolean.\n");
                            }
                          }
                          if($2->type==basicType[tBOOLEAN]){

                          $$=new Node;
                          instr * i;
                          string ** st = new string *;
                          *st = new string;

                          string l1=newLabel();
                          string l2=newLabel();

                          backpatch($2->True,l1);
                          backpatch($2->False,l2);

                          merge($$->Next,$4->Next);
                          merge($$->Next,$5->Next);
                          $$->Next.push_back(*st);

                          instrlist * list = new instrlist;
                          list->append($2->code);
                          i =instr::ic_label(l1);
                          list->addinstr(i);
                          list->append($4->code);
                          i =instr::ic_jump(*st);
                          list->addinstr(i);

                          i =instr::ic_label(l2);
                          list->addinstr(i);
                          list->append($5->code);

                          $$->code=list;
                          }

                        }
|                       
                        {
                          $$ = new Node;
                          $$->code = new instrlist;
                        }

;

Else:
  ELSE StatementSeq
                        {
                          $$ = $2;
                        }
|
                        {
                          $$ = new Node;
                          $$->code = new instrlist;
                        }
;

CaseList:
  Case
| Case '|' CaseList
;

Case: 
  CaseLabelList ':' StatementSeq
|
;

CaseLabelList:
  CaseLabels
| CaseLabels ',' CaseLabelList
;

CaseLabels: 
  ConstExpr 
| ConstExpr DOTS ConstExpr
;

GuardStatList :
  Guard DO StatementSeq '|' GuardStatList
| Guard DO StatementSeq 
;

Guard        : 
  Qualident ':' Qualident
;

ConstExpr    : 
  Expr      
            {
              if($1->cons==1){
                $$.error=false;
                $$.val=$1->val.argval.i;
              }
              else{
                $$.error=true;
                if($1->cons==2){
                  fprintf(stderr,"error %d:Expecting an INTEGER constant. Found REAL.\n",yylineno);
                }
                else{
                  fprintf(stderr,"error %d:Expecting an INTEGER constant.\n",yylineno);
                }
              }
            }
;

Expr         : 
  Expr '=' Expr 
                {
                  $$=new Node;
                  $$->cons=3;
                  $$->type = assign_rel_type($1->type,$3->type,yylineno);
                  if($$->type!=basicType[tERROR]){
                    genRelIC($$,$1,$3,R_E);
                  }
                }
| Expr '#' Expr 
                {
                  $$=new Node;
                  $$->cons=3;
                  $$->type = assign_rel_type($1->type,$3->type,yylineno);
                  if($$->type!=basicType[tERROR]){
                    genRelIC($$,$1,$3,R_NE);
                  }
                }
| Expr '<' Expr 
                { 
                  $$=new Node;
                  $$->cons=3;
                  $$->type = assign_rel_type($1->type,$3->type,yylineno);
                  if($$->type!=basicType[tERROR]){
                    genRelIC($$,$1,$3,R_L);
                  }
                }
| Expr LE Expr  
                { 
                  $$=new Node;
                  $$->cons=3;
                  $$->type = assign_rel_type($1->type,$3->type,yylineno);
                  if($$->type!=basicType[tERROR]){
                    genRelIC($$,$1,$3,R_LE);
                  }
                }
| Expr '>' Expr 
                {
                  $$=new Node;
                  $$->cons=3;
                  $$->type = assign_rel_type($1->type,$3->type,yylineno);
                  if($$->type!=basicType[tERROR]){
                    genRelIC($$,$1,$3,R_G);
                  }
                }
| Expr GE Expr  
                { 
                  $$=new Node;
                  $$->cons=3;
                  $$->val.argval.var  = getTemp();
                  $$->type = assign_rel_type($1->type,$3->type,yylineno);
                  if($$->type!=basicType[tERROR]){
                    genRelIC($$,$1,$3,R_GE);
                  }
                }
| Expr IN Expr  
                {
                  //Not to be implemented (Set datatype)
                }
| Expr IS Expr 
               {
                  $$->val.c = 0;
                  $$->cons=3;
                  $$->val.argval.var  = getTemp();
                 if( $3->type->node==-1){
                   //the second expression defines a type
                   $$->type = basicType[tBOOLEAN];
                 }
                 else  {
                   $$->type = basicType[tERROR];
                   if ($3->type!=basicType[tERROR])
                   fprintf(stderr,"Type error at %d: expression does not define a type\n",yylineno);
                 }
               }
| '+' Expr %prec UPLUS  
                { 
                  $$=new Node;
                  $$->val.c = 0;
                  $$->val.argval.var  = getTemp();
                  if (isArithmetic($2->type)){
                    $$ = $2;
                  }
                  else {
                    $$->type = basicType[tERROR];
                    if ($2->type!=basicType[tERROR])
                      fprintf(stderr,"Type error at %d: Not an arithmetic type\n",yylineno);
                  }
				}
| '-' Expr %prec UMINUS 
                { 
                  $$=new Node;
                  $$->val.c = 0;
                  $$->val.argval.var  = getTemp();
                  if (isArithmetic($2->type))
					$$->type = $2->type;
                  else {
                    $$->type = basicType[tERROR];
                    if ($2->type!=basicType[tERROR]){
                      fprintf(stderr,"Type error at %d: Not an arithmetic type\n",yylineno);
                      $$->type = basicType[tERROR];
                    }
                  }

                  if($$->type!=basicType[tERROR]){
                    genIC($$,$2,NULL,OP_MIN);
                  }

                  //TODO IC

				}

| Expr '+' Expr	
                {
                  $$=new Node;
                  $$->type = assign_add_type($1->type,$3->type,yylineno);
                  if($$->type!=basicType[tERROR]){
                    genIC($$,$1,$3,OP_ADD);
                  } 
                }
| Expr '-' Expr	
                {
                  $$=new Node;
                  $$->type = assign_add_type($1->type,$3->type,yylineno);
                  if($$->type!=basicType[tERROR]){
                    genIC($$,$1,$3,OP_SUB);
                  }
                }

| Expr OR Expr	
                { 
                  $$ = new Node;
                  $$->cons=3;

                  if ( CheckEquivalence($1->type,basicType[tBOOLEAN]) && CheckEquivalence($3->type,basicType[tBOOLEAN]) )
                    $$->type = basicType[tBOOLEAN];
                  else {
                    $$->type = basicType[tERROR];
                    if ( $1->type!=basicType[tERROR] && $3->type!=basicType[tERROR])
                      typeError(0,$1->type,basicType[tBOOLEAN],yylineno);
                  }

                  string s=newLabel();

                  backpatch($1->False,s);
                  merge($$->True,$1->True);
                  merge($$->True,$3->True);
                  merge($$->False,$3->False);
                  instrlist *list = new instrlist();
                  instr *inst1;
                  inst1 = instr::ic_label(s);
                  list->append($1->code);
                  list->addinstr(inst1);
                  list->append($3->code);
                  $$->code = list;

				}
| Expr '&' Expr	
                { 
                  $$ = new Node;
                  $$->cons = 3;
                  if ( CheckEquivalence($1->type,basicType[tBOOLEAN]) && CheckEquivalence($3->type,basicType[tBOOLEAN]) )
                    $$->type = basicType[tBOOLEAN];
                  else {
                    $$->type = basicType[tERROR];
                    if ( $1->type!=basicType[tERROR] && $3->type!=basicType[tERROR])
                      typeError(0,$1->type,basicType[tBOOLEAN],yylineno);
                  }

                  string s=newLabel();

                  backpatch($1->True,s);
                  merge($$->False,$1->False);
                  merge($$->False,$3->False);
                  merge($$->True,$3->True);

                  instrlist *list = new instrlist();
                  instr *inst1;
                  inst1 = instr::ic_label(s);
                  list->append($1->code);
                  list->addinstr(inst1);
                  list->append($3->code);
                  $$->code = list;
 
				}

| Expr '*' Expr	
                { 
                  $$=new Node;
                  $$->type = assign_add_type($1->type,$3->type,yylineno);
                  if($$->type!=basicType[tERROR]){
                    genIC($$,$1,$3,OP_MUL);
                  }
			    }
			    
| Expr '/' Expr	
                {
                  $$=new Node;
                  $$->type = assign_add_type($1->type,$3->type,yylineno);
                  if($$->type!=basicType[tERROR]){
                    genIC($$,$1,$3,OP_DIV);
                  }
                }
			    
| Expr DIV Expr	
                {
                  $$= new Node;
                  $$->val.c = 0;
                  $$->val.argval.var  = getTemp();
				  if (CheckEquivalence($1->type,basicType[tINTEGER]) && CheckEquivalence($3->type,basicType[tINTEGER]) )
					 $$->type = basicType[tINTEGER];
				  else {
				     $$->type = basicType[tERROR];
				     if ( $1->type!=basicType[tERROR] && $3->type!=basicType[tERROR])
				     fprintf(stderr,"Type error in division DIV at line number %d",yylineno);				    
				    } 
			    }
| Expr MOD Expr	
                { 
                  $$ = new Node;
                  $$->val.c = 0;
                  $$->val.argval.var  = getTemp();
				  if ( CheckEquivalence($1->type,basicType[tINTEGER]) && CheckEquivalence($3->type,basicType[tINTEGER]) )
					 $$->type = basicType[tINTEGER];
				  else {
				     $$->type = basicType[tERROR];
				     if ( $1->type!=basicType[tERROR] && $3->type!=basicType[tERROR])
				     fprintf(stderr,"Type error in division DIV at line number %d",yylineno);				    
				    } 
			    }
| Factor		
                { 
                  $$ = $1;
                }
;

Factor       : 
  Designator 
            {
                  $$=$1;
                  instr * in;
                  string tempvar;
                  instrlist * list;
                  list=new instrlist;
                  switch($$->dv.dclass){
                    case 0:
                        $$->cons=0;
                        $$->val.c=0;
                        $$->val.argval.var=$$->dv.var;
                        break;
                    case 1:
                        tempvar=getTemp();
                        $$->cons=0;
                        $$->val.c=0;
                        $$->val.argval.var=tempvar;
                        in = instr::ic_2arg(ARRR,makearg($1->dv.var),$1->dv.arg,tempvar);
                        list->addinstr(in);
                        break;
                    case 2:
                        tempvar=getTemp();
                        $$->cons=0;
                        $$->val.argval.var=tempvar;
                        in = instr::ic_2arg(RECR,makearg($1->dv.var),$1->dv.arg,tempvar); 
                        list->addinstr(in);
                        break;
                    default:
                        assert(false);
                  }
                  $$->code->append(list);
                  if($$->type==basicType[tBOOLEAN]){
                    $$->cons=0;
                    string * s1 = getLabelBox();
                    string * s2 = getLabelBox();
                    $$->True.push_back(s1);
                    $$->False.push_back(s2);

                    list = new instrlist;
                    instr *inst1, *inst2;
                    inst1 = instr::ic_cjump(R_E,&$$->val,Zero,s2);
                    inst2 = instr::ic_jump(s1);
                    list->addinstr(inst1);
                    list->addinstr(inst2);
                    $$->code->append(list);
                  }
            }
| CONSTnum  
            { 
               $$ = new Node;
               $$->type = basicType[tINTEGER];
               $$->val.c = 1;
               $$->cons = 1;
               $$->val.argval.i = atoi($1);
            }
| CONSTreal 
            { 
               $$ = new Node;
               $$->type = basicType[tREAL];
               $$->val.c = 2;
               $$->cons = 2;
               $$->val.argval.f = atof($1);
            }
| CONSTchar 
            { 
               //TODO
               $$ = new Node;
               $$->type = basicType[tCHAR];
            }

| CONSTstring { 
                //TODO
                $$ = new Node;
                $$->type = new TypeSpecifier(tPOINTER);
				$$->type->n = 1;
				$$->type->child = new TypeSpecifier *[1];
                $$->type->child[0] = basicType[tCHAR];
			  }
			  
| NIL 		  { 
                $$= new Node;
                $$->type= basicType[tVOID];
              }
| Set 		  { 
                $$= new Node;
                $$->type= NULL;
              }
| '(' Expr ')'
                {
                  $$=$2;
                }
| '~' Factor    
                { 
                  if(CheckEquivalence($2->type,basicType[tBOOLEAN])){
                    $$= $2;
                    swap($$->True,$$->False);
                  }
                  else{
                    $$->type=basicType[tERROR];
                  }
                  
                }
| TRUE          
                {
                  $$=new Node;
                  $$->cons=3;
                  $$->type=basicType[tBOOLEAN];
                  instr * inst1;
                  instrlist * list = new instrlist;
                  string ** st=new string *;
                  *st = new string;
                  inst1 = instr::ic_jump(*st);
                  $$->True.push_back(*st);
                  list->addinstr(inst1);
                  $$->code=list;
                }
| FALSE
                {
                  $$=new Node;
                  $$->cons=3;
                  $$->type=basicType[tBOOLEAN];
                  instr * inst1;
                  instrlist * list = new instrlist;
                  string ** st=new string *;
                  *st = new string;
                  inst1 = instr::ic_jump(*st);
                  $$->False.push_back(*st);
                  list->addinstr(inst1);
                  $$->code=list;
                }
;

Set          : 
  '{' optElementList '}'
;

optElementList :
  ElementList
| 
;

ElementList :
  Element ',' ElementList
| Element 
;

Element      : 
  Expr 
| Expr DOTS Expr
;

Designator   : 
  ident
                {
                  Entry *e = env->lookup(string($1));
                  if(e==NULL){
                     fprintf(stderr,"error at line %d: %s is not declared in this scope.\n",yylineno,$1);
                     expectedType.push(basicType[tERROR]);
                  }
                  else
                    expectedType.push(env->lookup(string($1))->type);
                  suffixArg.push(string($1));
                }
  optSuffix     {
                    $$ = new Node;
                    $$->type=designatorType.top();
                    designatorType.pop();
					suffixArg.pop();
                    //TODO
                    if($$->type!=basicType[tERROR]){
                        $$->cons=0;
                        $$->val.c=0;
                        if (designatorVar.empty()){
                          $$->dv = desigvar(string($1));
                        }
                        else{
                        $$->dv = designatorVar.top(); 
                        designatorVar.pop();                      
                        }
                    }
                    if ($3->code)
                    $$->code=$3->code;
                    else 
                    $$->code=new instrlist;
                }
;

optSuffix :        /* 
                        optSuffix has an inherited attribute expectedType that gives it its expected type
                        (from the identifier or through of sequence of procedure / array calls / pointer)
                   */
  '.' ident     {
                  
                  TypeSpecifier * tmp = expectedType.top();
                  string tempvar= getTemp();
                  suffixArg.push(tempvar);
                  
                  if (tmp->node = tRECORD){
                     envStack.push(env);
                     env = tmp->rectab;
                     //printf("Push env\n");
                     Entry *e = env->lookup(string($2));
                     if(e==NULL){
                         fprintf(stderr,"error at line %d: %s is not declared in this scope.\n",yylineno,$2);
                         expectedType.push(basicType[tERROR]);
                     }
                     else
                     expectedType.push(e->type);
                  }
                  else
                  {
                     fprintf(stderr,"error at line %d: invalid record reference. not a record\n",yylineno);
                     expectedType.push(basicType[tERROR]);
                  }

                  
                }
      optSuffix
                {
                   string tempvar = suffixArg.top();
                   suffixArg.pop();
                   string parentvar = suffixArg.top();
                   $$ = new Node;
                   $$->type = expectedType.top();
                   expectedType.pop();
                   env=envStack.top();
                   envStack.pop();
                   //printf("Pop env\n");
                   genICRecordR($$,$2,$4,tempvar,parentvar,$4->suffixEnd);
                   if(!$$->suffixEnd) tempCount--;
                   $$->suffixEnd=false;
                }

| '[' ExprList ']'  
                 {
                   TypeSpecifier * tmp = expectedType.top();
                   string tempvar= getTemp();
                   suffixArg.push(tempvar);
                   //validate array call{{{
                   if(tmp->node == tARRAY){
                     if($2->size==tmp->n){
                       bool flag=false;
                       NodeList *nl=$2;
                       for(int i=0; i<tmp->n; i++){
                         if(nl->head->type->node!=tINTEGER){
                           flag=true;
                           fprintf(stderr,"error at line %d: Invalid argument to array. Expecting INTEGER type at argument %d.\n",yylineno,i+1);
                         }
                         nl=nl->tail;
                       }
                       if(flag){
                         expectedType.push(basicType[tERROR]);
                       }
                       else{
                         expectedType.push(tmp->child[0]);
                       }
                     }
                     else{
                       fprintf(stderr,"error at line %d: Invalid number of dimensions in array call.\n",yylineno);
                       expectedType.push(basicType[tERROR]);
                     }
                   }
                   else{
                     fprintf(stderr,"error at line %d: invalid array call. not a array\n",yylineno);
                     expectedType.push(basicType[tERROR]);
                   }
                   // TODO IMP: memory leak - need to delete the type list 
                   //}}}
                   
                 }

    optSuffix   
                 {
                   string tempvar = suffixArg.top();
                   suffixArg.pop();
                   string parentvar = suffixArg.top();
                   $$ = new Node;
				   $$->type = expectedType.top();
                   expectedType.pop();
                   if(!$$->suffixEnd) tempCount--;
                   genICArrayR($$,$2,$5,tempvar,parentvar,$5->suffixEnd);
                   $$->suffixEnd=false;
                 }
| '^'  optSuffix
                {
                   $$ = new Node;
                   $$->val.c = 0;
                   $$->suffixEnd=false;
                }
| '(' ExprList ')' 
                    {
                      TypeSpecifier * tmp = expectedType.top();
                      string tempvar = getTemp();
                      suffixArg.push(tempvar);
                      //Validate Function Call{{{
                      if(tmp!=basicType[tERROR]){
                        if(tmp->node == tPROCEDURE){
                          validateFunctionCall(tmp,$2,yylineno);
                          expectedType.push(tmp->child[0]);
                        }
                        else{
                          fprintf(stderr,"error at line %d: Invalid procedure call. not a procedure\n",yylineno);
                          expectedType.push(basicType[tERROR]);
                        }
                        // TODO IMP: memory leak - need to delete the type list 
                      }
                      else{
                        expectedType.push(basicType[tERROR]);
                      }
                      //}}}
                    }
    optSuffix  
                {
                  //Assuming function does not return derived type
                  string tempvar = suffixArg.top();
                  suffixArg.pop();
                  string parentvar = suffixArg.top();
                  $$ = new Node;
                  $$->type = expectedType.top();
                  expectedType.pop();
                  if($$->type!=basicType[tERROR]){
                    string funcLabel;
                    funcLabel = env->lookup(parentvar)->label;
                    genICFunc($$,$2,tempvar,funcLabel);
                  }
                  if($5->suffixEnd){
                    designatorVar.push(desigvar(tempvar,0));
                  }
                  $$->suffixEnd=false;
                }
| '(' ')' 
                    {
                      TypeSpecifier * tmp = expectedType.top();
                      if(tmp!=basicType[tERROR]){
                        if(tmp->node == tPROCEDURE){
                          if(tmp->n==1)
                            expectedType.pop();
                          expectedType.push(tmp->child[0]);
                        }
                        else{
                          fprintf(stderr,"error at line %d: Invalid procedure call. not a procedure\n",yylineno);
                          expectedType.pop();
                          expectedType.push(basicType[tERROR]);
                        }
                        // TODO IMP: memory leak - need to delete the type list 
                      }
                    }

   optSuffix    
                {
                  $$ = new Node;
                  $$->code = new instrlist;
                  $$->suffixEnd=false;
                }
|
                {
                  $$ = new Node;
                  $$->code = new instrlist;
                  $$->suffixEnd=true;
                  designatorType.push(expectedType.top());
                  expectedType.pop();
                }
;

ExprList     : 
  Expr              {
                        $$ = new NodeList;
                        $$->head=$1;
                        $$->size=1;
                        $$->tail=NULL;
                    }
| Expr ',' ExprList { 
                        $$ = new NodeList;
                        $$->head=$1;
                        $$->tail=$3;
                        $$->size=$$->tail->size+1;
					}
;

IdentDefList    : 
  IdentDef      { identLists.top().push($1); 
                /*printf("push in list - %s size of list %d \n",$1,identList.size());*/ }
| IdentDef ','  { identLists.top().push($1); 
                /*printf("push in list - %s size of list %d \n",$1,identList.size());*/ }
  IdentDefList
                
;

Qualident    : 
  ident         { 
                  $$=strdup($1);
                }
| ident '.' ident 
                { 
                  $$=new char[strlen($1)+strlen($3)+1];
                  strcpy($$,$1);
                  strcat($$,".");
                  strcat($$,$3);
                }

;

IdentDef     : 
  ident        { $$ = strdup($1); }
| ident '*' 
| ident '-'
;


%%

/*
 *
 * Create the basic types and store them in the global array basicType.
 * Also create their symbol table entries.
 *
 */

void createBasicTypes(){
  string name[] =  {"BOOLEAN","CHAR","SHORTINT","INTEGER","LONGINT",
                    "REAL","LONGREAL","SET","VOID","ERROR"};
  int size[]={1,1,2,4,8,4,8,1,1,1};
  TypeSpecifier * t;
  for(int i=0; i<10; i++){
    t=new TypeSpecifier(i,size[i]);
    env->insertType(name[i],t);
    basicType[i]=t;
  }
}


int main(int argc, char* argv[]){
  char * output=(char *)"output.asm";
  if(argc<2){
    error("Usage:\toberon2 [FLAG] file\n");
    exit(1);
  }
  for(int i=0;i<argc; i++){
    if(strcmp(argv[i], "-o")==0)
      output=strdup(argv[++i]);
    if(strcmp(argv[i], "--typeCheck")==0)
      typeCheck = true;
    if(strcmp(argv[i], "--printLeaders")==0)
      printLeaders = true;
    if(strcmp(argv[i], "--printIC")==0)
      printIC = true;
    if(strcmp(argv[i], "--showOpt")==0)
      showOpt = true;
  }
  of=fopen(output,"w");
  extern FILE * yyin;
  yyin=fopen(argv[1],"r");
  if(!yyin){
    error("Can't open file!\n");
    exit(1);
  }
  env = new Scope();
  createBasicTypes();
  int res = yyparse();
  //env->showAll();
  delete env;
  printf("\n");
  fclose(of);
  if (res==0)
    debug("Successful parse\n");
  else
    debug("Encountered errors\n");
  exit(res);
}



