import sys
from cs365 import *

class Agent:
    def __init__(self):
        self.agentX = 0;
        self.agentY = 0;
        self.mapLength = 0;
        self.mapWidth = 0;
        self.memoryMap = [];
        self.mapList = {};
        self.numObjects = 0;
        self.objectList = {};
        self.lostObjects=[];
        self.foundObjects=[];
        self.boundaryObjects=[];
        self.objectFixed ={};
        self.percept = [];
        self.head = 0; 
        # default head is north
        # 0-North, 1-East, 2-South, 3-West

        
    # display the memory map of the robot
    def displayMemory(self):
        for row in self.memoryMap:
            print row
            
    # a function for returning the location in the desired format
    # from the memory map of the robot
    def notifyObjects(self):
        objects = [];
        xList = {};
        yList = {};
        for x in range(self.mapLength):
            for y in range(self.mapWidth):
                objID = self.memoryMap[x][y]
                if objID == 0: continue;
                if objID not in objects:
                    objects.append(objID);
                    xList[objID] = [];
                    yList[objID] = [];
                xList[objID].append(x+1);
                yList[objID].append(y+1);

        for objID in objects:
            minX = min(xList[objID]);
            maxX = max(xList[objID]);
            minY = min(yList[objID]);
            maxY = max(yList[objID]);
            
            writeObjectInfo( (objID, ((minX,minY),(maxX,maxY)) ) );
            

    def decideDirAnti(self):
        if self.percept[7]==1:
            if self.percept[0]==0: return "lDiag";
            elif self.percept[1]==0: return "forward";
            else: return "right";

    def decideDirClock(self):
        if self.percept[3]==1:
            if self.percept[2]==0: return "rDiag";
            elif self.percept[1]==0: return "forward";
            else: return "left";
        return "error";   

    def sense(self):
        percept = sense();
        if self.head == 0:
            return percept;
        elif self.head == 1:
            return [ percept[6],percept[7],percept[0],
                     percept[1],percept[2],percept[3],
                     percept[4],percept[5]];
        elif self.head == 2:
            return [ percept[4],percept[5],percept[6],
                     percept[7],percept[0],percept[1],
                     percept[2],percept[3]];
        else:
            return [ percept[2],percept[3],percept[4],
                     percept[5],percept[6],percept[7],
                     percept[0],percept[1]];
                     
    def getID(self,i):
        if self.head == 0:
            return getId(i);
        elif self.head == 1:
            t = (i+6)%8;
            if t ==0: return getId(8);
            else: return getId(t)
        elif self.head == 2:
            t = (i+4)%8;
            if t ==0: return getId(8)
            else: return getId(t)
        else:
            t = (i+2)%8;
            if t ==0: return getId(8)
            else: return getId(t)

    def changeHead(self,direction):
        if direction == "left":
            self.head = (self.head+1)%4
        elif direction == "right":
            self.head = (self.head+3)%4            
        
    def moveIn(self,direction):
        if self.head ==0:
            if direction=="forward":
                if move(2):
                    self.agentY+=1;
                    return True;
                else: return False;
            if direction=="left":
                if move(8):
                    self.agentX-=1;
                    self.head = 1;
                    return True;
                else: return False;
            if direction=="right":
                if move(4):
                    self.agentX+=1;
                    self.head = 3;
                    return True;
                else: return False;
            if direction=="rDiag":
                if move(3):
                    self.agentX+=1;
                    self.agentY+=1;
                    self.head = 3;
                    return True;
                else: return False;
            if direction=="lDiag":
                if move(1):
                    self.agentX-=1;
                    self.agentY+=1;
                    self.head = 1;
                    return True;
                else: return False;
                
        elif self.head ==1:
            if direction=="forward":
                if move(8):
                    self.agentX-=1;
                    return True;
                else: return False;
            if direction=="left":
                if move(6):
                    self.agentY-=1;
                    self.head = 2;
                    return True;
                else: return False;
            if direction=="right":
                if move(2):
                    self.agentY+=1;
                    self.head = 0;
                    return True;
                else: return False;
            if direction=="rDiag":
                if move(1):
                    self.agentX-=1;
                    self.agentY+=1;
                    self.head = 0;
                    return True;
                else: return False;
            if direction=="lDiag":
                if move(7):
                    self.agentX-=1;
                    self.agentY-=1;
                    self.head = 2;
                    return True;
                else: return False;
                
        elif self.head ==2:
            if direction=="forward":
                if move(6):
                    self.agentY-=1;
                    return True;
                else: return False;
            if direction=="left":
                if move(4):
                    self.agentX+=1;
                    self.head = 3;
                    return True;
                else: return False;
            if direction=="right":
                if move(8):
                    self.agentX-=1;
                    self.head = 1;
                    return True;
                else: return False;
            if direction=="rDiag":
                if move(7):
                    self.agentX-=1;
                    self.agentY-=1;
                    self.head = 1;
                    return True;
                else: return False;
            if direction=="lDiag":
                if move(5):
                    self.agentX+=1;
                    self.agentY-=1;
                    self.head = 3;
                    return True;
                else: return False;
                
        elif self.head ==3:
            if direction=="forward":
                if move(4):
                    self.agentX+=1
                    return True;
                else: return False;
            if direction=="left":
                if move(2):
                    self.agentY+=1;
                    self.head = 0;
                    return True;
                else: return False;
            if direction=="right":
                if move(6):
                    self.agentY-=1;
                    self.head = 2;
                    return True;
                else: return False;
            if direction=="rDiag":
                if move(5):
                    self.agentX+=1;
                    self.agentY-=1;
                    self.head = 2;
                    return True;
                else: return False;
            if direction=="lDiag":
                if move(3):
                    self.agentX+=1;
                    self.agentY+=1;
                    self.head = 0;
                    return True;
                else: return False;
        
        
    def markMemory(self,direction,objID):
          if self.head == 0:    
              self.mapList[self.agentX+1,self.agentY] = objID;
          elif self.head == 1:
              self.mapList[self.agentX,self.agentY+1] = objID;
          elif self.head == 2:
              self.mapList[self.agentX-1,self.agentY] = objID;
          else:
              self.mapList[self.agentX,self.agentY-1] = objID;

    def undoTempList(self,x,y,list):
        i = len(list)-2;
        while (i>=0):
          self.moveToCell(list[i]);
          i = i-1;

    def travelLostObject(self,objID):
        return self.travelNewObject(objID);

    def travelFakeObject(self,objID):
        tempList = [];
        initX = self.agentX;
        initY = self.agentY;
        
        if self.head == 3:
            self.head = 2;
            while True:
                id = self.getID(8);

                if (id ==-1):
                    self.undoTempList(initX,initY,tempList);
                    return False;
                 
                if not self.moveIn("lDiag"):
                    if not self.moveIn("forward"):
                        self.changeHead("right");
                        continue;
                if (self.agentX,self.agentY) not in tempList:    
                    tempList.append( (self.agentX,self.agentY));         
                if (self.agentX>initX) and (self.agentY==initY):
                    self.head = 3;
                    return True;
                    
        elif self.head == 1:
            self.head = 2;
            while True:
                id = self.getID(4);

                if (id ==-1):
                    self.undoTempList(initX,initY,tempList);
                    return False;
                        
                if not self.moveIn("rDiag"):
                    if not self.moveIn("forward"):
                        self.changeHead("left");
                        continue;

                if (self.agentX,self.agentY) not in tempList:    
                    tempList.append( (self.agentX,self.agentY));         
                if (self.agentX<initX) and (self.agentY==initY):
                    self.head = 1;
                    return True;

        
    # travels new object till it reaches its intial position marking its boundary
    # in the memory map of the object. Represent each object in the map by the
    # sequence of its object id
    def travelNewObject(self,objID):
        tempList = [];
        idList = [objID];
        initX = self.agentX;
        initY = self.agentY;
        self.mapList = {};
        tempList.append((self.agentX,self.agentY));
              
        if self.head ==3:
            self.head = 0;
            while True:              
                # now it ensured that there will always be an object to its right
                # if it is not, that means the object has moved and we should go
                # back to init position
                id = self.getID(4);
                               
                if (id ==-1):
                    self.undoTempList(initX,initY,tempList);
                    self.mapList = {};
                    for i in idList:
                        if i not in self.lostObjects:
                            self.lostObjects.append(i);
                    return False;
                    
                else:
                    if id not in idList:
                        idList.append(id);
                    self.markMemory("right",id);
                    
                if not self.moveIn("rDiag"):
                    if not self.moveIn("forward"):
                        self.changeHead("left");
                        continue;
                tempList.append((self.agentX,self.agentY));
                if (self.agentX,self.agentY)==(initX,initY): break;
            self.head = 3;

        elif self.head ==1:
            self.head = 2;
            while True:
                
                id = self.getID(4);
                if (id ==-1):
                    self.undoTempList(initX,initY,tempList);
                    self.mapList = {};
                    for i in idList:
                        if i not in self.lostObjects:
                            self.lostObjects.append(i);
                    return False;
                
                else:
                    if id not in idList:
                        idList.append(id);
                    self.markMemory("right",id);
                    
                self.percept = self.sense();
                if not self.moveIn("rDiag"):
                    if not self.moveIn("forward"):
                        self.changeHead("left");
                        continue;

                tempList.append((self.agentX,self.agentY));      
                if (self.agentX,self.agentY)==(initX,initY): break;
            self.head = 1;
            

        
        
        for i in idList:
            self.objectList[i] = tempList;
        for i in self.mapList:
        
            if self.mapList[i] in self.lostObjects:
                self.lostObjects.remove(self.mapList[i]);
            self.memoryMap[i[0]][i[1]]=self.mapList[i];
        self.mapList={};
        return True;

        
    def moveToCell(self,point):
       
        if point==(self.agentX-1,self.agentY+1): move(1)
        elif point==(self.agentX,self.agentY+1): move(2);
        elif point==(self.agentX+1,self.agentY+1): move(3)
        elif point==(self.agentX+1,self.agentY): move(4);
        elif point==(self.agentX+1,self.agentY-1): move(5)
        elif point==(self.agentX,self.agentY-1): move(6);
        elif point==(self.agentX-1,self.agentY-1): move(7)
        elif point==(self.agentX-1,self.agentY): move(8);
        
        self.agentX = point[0];
        self.agentY = point[1];


    # Travels an old object from the bottom, clockwise if from right,
    # anticlockeise if from left.
    def travelOldObject(self,ObjID):
        list = self.objectList[ObjID]
        initX = self.agentX;
        initY = self.agentY;

        if self.head == 1:
            minPoint = (self.mapLength+1,self.mapLength+1);
            for point in list:
                if point[1]==initY:
                    if minPoint[0] > point[0]:
                        minPoint = point;

            
            i = list.index((self.agentX,self.agentY));            
            while (self.agentX,self.agentY)!= minPoint:
              if ( i == len(list)-1): i=-1;
              
              self.moveToCell(list[i+1]);
              i = i+1;
            
        elif self.head == 3:
            maxPoint = (-1,-1);
            for point in list:
                if point[1]==initY:
                    if point[0]==initX: continue;
                    if maxPoint[0] < point[0]:
                        maxPoint = point;
                        
            
            i = list.index( (self.agentX,self.agentY));            
            while (self.agentX,self.agentY)!= maxPoint:
              if (i==0): i=len(list);
              self.moveToCell(list[i-1]);
              i = i-1;
            
        
        

    def handleBoundaryObject(self,objID):
        list = self.objectList[objID];
        
        initX = self.agentX;
        initY = self.agentY;
        flag = 1;
        
        if self.head == 3:
            
            maxPoint = (-1,-1);
            ref = list.index( (self.agentX,self.agentY));
            i = 0;
            for i in range(len(list)):
                if list[i][1]==initY:
                    if list[i][0]<=initX: continue;
                    if maxPoint[0] < list[i][0]:
                        maxPoint = list[i];
                        
            
            if maxPoint == (-1,-1):
                return True;

            ref1 = list.index(maxPoint);
            if ref<ref1:
                while (self.agentX,self.agentY)!= maxPoint:
                  self.moveToCell(list[ref+1]);
                  ref = ref+1;
            else:
                while (self.agentX,self.agentY)!= maxPoint:
                  self.moveToCell(list[ref-1]);
                  ref = ref-1;
                            
        elif self.head == 1:
            
            minPoint = (self.mapLength+1,self.mapWidth+1);
            ref = list.index( (self.agentX,self.agentY));
            i = 0;
            for i in range(len(list)):
                if list[i][1]==initY:
                    if list[i][0]>=initX: continue;
                    if minPoint[0] > list[i][0]:
                        minPoint = list[i];
                        
            
            if minPoint == (self.mapLength+1,self.mapWidth+1):
                return True;

            ref1 = list.index(minPoint);
            if ref<ref1:
                while (self.agentX,self.agentY)!= minPoint:
                  self.moveToCell(list[ref+1]);
                  ref = ref+1;
            else:
                while (self.agentX,self.agentY)!= minPoint:
                  self.moveToCell(list[ref-1]);
                  ref = ref-1;

        return False;
         
    # Traversing the current row depending on even or odd and covering the
    # boundary of any new object. Each objects is checked for to be new or
    # old using memory of the robot.
    def exploreRow(self):
        if (self.agentY % 2 == 0):
            self.head = 3;
            while (self.agentX != self.mapLength-1):      
                
                objID = self.memoryMap[self.agentX+1][self.agentY]
                
                if objID == 0:
                    if not self.moveIn("forward"):
                            objID = self.getID(2)
                            
                            if objID in self.lostObjects:
                                if self.objectFixed[objID] == (self.agentX,self.agentY):                                    
                                    
                                    if self.travelLostObject(objID):
                                        self.travelOldObject(objID)
                                else: self.travelFakeObject(objID);
                            else:                                    
                                
                                self.objectFixed[objID]=(self.agentX,self.agentY);
                                if self.travelNewObject(objID):
                                    self.travelOldObject(objID)
                                else:   
                                    if objID not in self.lostObjects:
                                        
                                        self.lostObjects.append(objID);
                            self.head = 3;
                            
                elif objID in self.boundaryObjects:
                    flag = self.handleBoundaryObject(objID)
                    if flag==True: break;
                    
                else:       self.travelOldObject(objID)

        else:
            self.head = 1  
            while (self.agentX != 0):
                
                objID = self.memoryMap[self.agentX-1][self.agentY]
                if objID == 0:
                    if not self.moveIn("forward"):
                            objID = self.getID(2)
                            
                            if objID in self.lostObjects:
                                if self.objectFixed[objID] == (self.agentX,self.agentY):                                    
                                    
                                    if self.travelLostObject(objID):
                                        self.travelOldObject(objID)
                                else: self.travelFakeObject(objID);    
                            else:                                    
                                
                                self.objectFixed[objID]=(self.agentX,self.agentY);
                                if self.travelNewObject(objID):
                                    self.travelOldObject(objID)
                                else:   
                                    if objID not in self.lostObjects:
                                        
                                        self.lostObjects.append(objID);
                            self.head = 1;
                            
                elif objID in self.boundaryObjects:
                    flag = self.handleBoundaryObject(objID)
                    if flag==True: break;
                    
                else:       self.travelOldObject(objID)
        return True;
                 
                    
    # traverse the boundary of any new object till its y=0 for first time with x>0
    def zeroYoffset(self):
        initX = self.agentX;
        initY = self.agentY;
        

        objID = self.getID(2);
        if objID == 0: return -1;
        elif objID in self.boundaryObjects:
            list = self.objectList[objID];
            
            while(self.getID(2)!=0):
                if not self.moveIn("lDiag"):
                    if not self.moveIn("forward"):
                        self.changeHead("right");
                        continue;

            
            self.agentX = list[0][0];
            self.agentY = list[0][1];
            return 1;
            
        else:
            self.head = 0;
            while True:
                self.percept = self.sense();
                
                if not self.moveIn("rDiag"):
                    if not self.moveIn("forward"):
                        self.changeHead("left");
                        continue;

                if (self.agentX>initX) and (self.agentY==initY):
                    self.head = 3;
                    return 0;
           

    # For initial alignment of the bot. The bot first moves to extreme right while
    # moving around any object obstructing in path, remaining in the same current row.
    # It then moves to bottom. At this point, the bot is at (n,0). It then reaches
    # to (0,0) to calculate the size of the grid.
    def initialAlign(self):
        self.head = 3;
        flag = 0

        while (flag==0):
            
            if not self.moveIn("forward"):# treat like first time traversal
                flag = self.zeroYoffset() # such that first time y offset is 0
                                          # in the positive direction

        while True:
            self.head = 2;
            objID = self.getID(2);
            if objID == 0: break;
            elif objID==-1:
                self.moveIn("forward");
                continue;
            while(self.getID(2)!=0):
                if not self.moveIn("lDiag"):
                    if not self.moveIn("forward"):
                        self.changeHead("right");
                        continue;

        while True:
            self.head = 1;
            objID = self.getID(2);
            if objID == 0: break;
            elif objID==-1:
                self.moveIn("forward");
                continue;
            while(self.getID(2)!=0):
                if not self.moveIn("lDiag"):
                    if not self.moveIn("forward"):
                        self.changeHead("right");
                        continue;


        self.agentX = 0;
        self.agentY = 0;
        self.head = 3;
        

    def outlineBoundary(self):
        
        self.head = 3;
        while True:
            if not self.moveIn("forward"):
                objID = self.getID(2);
                if objID==0:
                    self.changeHead("left");
                else:
                    
                    self.changeHead("left");
                    idList = [objID];
                    self.mapList = {};
                    tempList=[];
                    tempList.append((self.agentX,self.agentY));
                    
                    while(self.getID(2)!=0):
                        self.markMemory("right",objID);
                        if not self.moveIn("rDiag"):
                            if not self.moveIn("forward"):
                                self.changeHead("left");
                                continue;

                        tempList.append((self.agentX,self.agentY));    
                        objID = self.getID(4);
                        if objID not in idList:
                            idList.append(objID);
                    self.markMemory("right",objID);    

                    self.changeHead("left");
                    for i in self.mapList:
                       
                        self.memoryMap[i[0]][i[1]]=self.mapList[i];
                    self.mapList={};
                    for i in idList:
                        self.boundaryObjects.append(i);
                       
                        self.objectList[i] = tempList;
                        
            if (self.agentX,self.agentY)==(0,0): break;

                    
    def calculateMemoryMap(self):
        self.head = 0;
        maxX = 0;
        maxY = 0;
        
        while True:
            if not self.moveIn("lDiag"):
                if not self.moveIn("forward"):
                    self.changeHead("right");
                    continue;

            maxX= max(maxX,self.agentX);
            maxY= max(maxY,self.agentY);
            if (self.agentX==0) and (self.agentY==0):
                self.head = 3;
                break;

        self.mapLength = maxX+1;
        self.mapWidth = maxY+1;
        
    
               
    def exploreGridLost(self):
        self.agentX = 0;
        self.agentX = 0;
        self.initialAlign();
        
        while True:
            self.exploreRow();
            
            self.head=0;
            

            objID = self.getID(2);
            if objID==-1: self.moveIn("forward");
            elif objID==0: break
            else:
                               
                list = self.objectList[objID];
                initX = self.agentX;
                initY = self.agentY;
                
                if self.agentY % 2 == 1:
                    i = 0;
                    maxPoint = (-1,-1);
                    for i in range(len(list)):
                        if list[i][1]==initY+1:
                            if maxPoint[0] < list[i][0]:
                                maxPoint = list[i];
        
                    i = list.index((self.agentX,self.agentY));
                    
                    while (self.agentX,self.agentY)!= maxPoint:
                      self.moveToCell(list[i-1]);
                      i = i-1;

                else:
                    i = 0;
                    minPoint = (self.mapLength+1,self.mapWidth+1);
                    for i in range(len(list)):
                        if list[i][1]==initY+1:
                            if minPoint[0] > list[i][0]:
                                minPoint = list[i];

                    i = list.index((self.agentX,self.agentY));
                    
                    while (self.agentX,self.agentY)!= minPoint:
                      self.moveToCell(list[i+1]);
                      i = i+1;
                    

        if self.lostObjects != []:
            restart();
            self.exploreGridLost();
                


    # main function to explore the grid. The position of the bot is now at 0,0
    # The bot will move the y=even rows from right and y=odd from left.
    def exploreGrid(self):
        self.agentX = 0;
        self.agentY = 0;
        self.calculateMemoryMap();

        self.memoryMap = [[0]*self.mapWidth for x in xrange(self.mapLength)];
        self.outlineBoundary();
        
        
        while True:
            self.exploreRow();
            
            self.head=0;
                     

            objID = self.getID(2);
            if objID==-1: self.moveIn("forward");
            elif objID==0: break
            else:
                
                
                list = self.objectList[objID];
                
                initX = self.agentX;
                initY = self.agentY;
                
                if self.agentY % 2 == 1:
                    i = 0;
                    maxPoint = (-1,-1);
                    for i in range(len(list)):
                        if list[i][1]==initY+1:
                            if maxPoint[0] < list[i][0]:
                                maxPoint = list[i];
        
                    i = list.index((self.agentX,self.agentY));
                    
                    while (self.agentX,self.agentY)!= maxPoint:
                      self.moveToCell(list[i-1]);
                      i = i-1;

                else:
                    i = 0;
                    minPoint = (self.mapLength+1,self.mapWidth+1);
                    for i in range(len(list)):
                        if list[i][1]==initY+1:
                            if minPoint[0] > list[i][0]:
                                minPoint = list[i];

                    i = list.index((self.agentX,self.agentY));
                    
                    while (self.agentX,self.agentY)!= minPoint:
                      self.moveToCell(list[i+1]);
                      i = i+1;
                    
            
        if self.lostObjects != []:
            restart();
            self.exploreGridLost();
      

    def run(self):
        self.exploreGrid();

        
def main():
    writeRollNo("Y8140");
    writeName("ASHISH GUPTA");
    for level in range(1,4):
        generateGrid(level);
        agent = Agent();
        agent.run();
        agent.notifyObjects();
    stop();
    
main()
